<?php

/**
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is protected by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2018 Lifestyle Webconsulting GmbH
 * @version    $Id:$
 * @link       http://www.life-style.de
 */

use Symfony\Component\HttpKernel\Kernel;
use Symfony\Component\Config\Loader\LoaderInterface;

/**
 * Class AppKernel
 */
class AppKernel extends Kernel
{

    /**
     * AppKernel constructor.
     * @param string $environment
     * @param bool $debug
     */
    public function __construct($environment, $debug)
    {
        date_default_timezone_set('Europe/Berlin');
        parent::__construct($environment, $debug);
    }

    /**
     * @return array|\Symfony\Component\HttpKernel\Bundle\BundleInterface[]
     */
    public function registerBundles()
    {
        $bundles = array(
            new Symfony\Bundle\FrameworkBundle\FrameworkBundle(),
            new Symfony\Bundle\SecurityBundle\SecurityBundle(),
            new Symfony\Bundle\TwigBundle\TwigBundle(),
            new Symfony\Bundle\MonologBundle\MonologBundle(),
            new Symfony\Bundle\SwiftmailerBundle\SwiftmailerBundle(),
            new Symfony\Bundle\AsseticBundle\AsseticBundle(),
            new Doctrine\Bundle\DoctrineBundle\DoctrineBundle(),
            new Doctrine\Bundle\MigrationsBundle\DoctrineMigrationsBundle(),
            new Sensio\Bundle\FrameworkExtraBundle\SensioFrameworkExtraBundle(),
            new Sso\BackendBundle\SsoBackendBundle(),
            new Sso\HelpBundle\SsoHelpBundle(),
            new Sso\DemoBundle\SsoDemoBundle(),
            new FOS\UserBundle\FOSUserBundle(),
            new Lexik\Bundle\FormFilterBundle\LexikFormFilterBundle(),
            //new JordiLlonch\Bundle\CrudGeneratorBundle\JordiLlonchCrudGeneratorBundle(),
            new Ddeboer\DataImportBundle\DdeboerDataImportBundle(),
            new JMS\SerializerBundle\JMSSerializerBundle(),
            new JMS\AopBundle\JMSAopBundle(),
           // new JMS\SecurityExtraBundle\JMSSecurityExtraBundle(),
            new JMS\DiExtraBundle\JMSDiExtraBundle(),
            new Knp\Bundle\PaginatorBundle\KnpPaginatorBundle(),
            // load LifeStyle Tools
            new LifeStyle\Tools\BackendSecurityBundle\LifeStyleToolsBackendSecurityBundle(),
            new LifeStyle\Tools\DbLogBundle\LifeStyleToolsDbLogBundle(),
            new LifeStyle\Tools\XmlBundle\LifeStyleToolsXmlBundle(),
            new LifeStyle\Tools\WebserviceBundle\LifeStyleToolsWebserviceBundle(),
            new LifeStyle\Tools\CredentialsBundle\LifeStyleToolsCredentialsBundle(),
            new LifeStyle\Tools\ORMHelperBundle\LifeStyleToolsORMHelperBundle(),
            new Sso\Tools\UserIdentifierBundle\SsoToolsUserIdentifierBundle(),
            new Sso\ApiBundle\SsoApiBundle(),
            new Sso\Webservices\DefaultBundle\SsoWebservicesDefaultBundle(),
            new Sso\Webservices\ObjectBundle\SsoWebservicesObjectBundle(),
            new Sso\ReportingBundle\SsoReportingBundle(),
            new Sso\AccessBundle\SsoAccessBundle(),
        );

        if (in_array($this->getEnvironment(), ['dev', 'test', 'of', 'sb', 'staging', 'cb', 'mh', 'mb'], true)) {
            $bundles[] = new Webfactory\Bundle\ExceptionsBundle\WebfactoryExceptionsBundle();
            $bundles[] = new Symfony\Bundle\WebProfilerBundle\WebProfilerBundle();
            $bundles[] = new Sensio\Bundle\DistributionBundle\SensioDistributionBundle();
            $bundles[] = new Sensio\Bundle\GeneratorBundle\SensioGeneratorBundle();
            $bundles[] = new Symfony\Bundle\DebugBundle\DebugBundle();
        }

        if ($this->getEnvironment() === 'test') {
            $bundles[] = new Doctrine\Bundle\FixturesBundle\DoctrineFixturesBundle();
        }

        return $bundles;
    }

    /**
     * @param LoaderInterface $loader
     * @throws Exception
     */
    public function registerContainerConfiguration(LoaderInterface $loader)
    {
        $loader->load(__DIR__ . '/config/config_' . $this->getEnvironment() . '.yml');
    }

    /**
     * @return string
     */
    public function getRootDir()
    {
        return __DIR__;
    }

    /**
     * @return string
     */
    public function getCacheDir()
    {
        return dirname(__DIR__).'/var/cache/'.$this->getEnvironment();
    }

    /**
     * @return string
     */
    public function getLogDir()
    {
        return dirname(__DIR__).'/var/logs';
    }
}
