<?php

namespace Application\Migrations;

use Doctrine\DBAL\Migrations\AbstractMigration;
use Doctrine\DBAL\Schema\Schema;
use Symfony\Component\DependencyInjection\ContainerAwareInterface;
use Symfony\Component\DependencyInjection\ContainerInterface;

/**
 * Initialize tables for webservice database
 *
 * @copyright  2016 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 * @package Application\Migrations
 */
class Version20160607213310 extends AbstractMigration implements ContainerAwareInterface
{
    /**
     * @var ContainerInterface
     */
    private $container;

    /**
     * @param Schema $schema
     */
    public function up(Schema $schema)
    {
        $this->skipIf($this->connection->getDatabase() !== $this->getConfiguredDatabaseName(), 'Skipped migration. Database does not match.');

        $this->abortIf($this->connection->getDatabasePlatform()->getName() != 'mysql', 'Migration can only be executed safely on \'mysql\'.');

        $this->addSql('CREATE TABLE obj_attribute (id CHAR(36) NOT NULL COMMENT \'(DC2Type:uuid)\', attribute_group_id CHAR(36) NOT NULL COMMENT \'(DC2Type:uuid)\', name VARCHAR(255) NOT NULL, lower_name VARCHAR(255) NOT NULL, created DATETIME NOT NULL, updated DATETIME NOT NULL, INDEX IDX_489535262D643B7 (attribute_group_id), PRIMARY KEY(id)) DEFAULT CHARACTER SET utf8 COLLATE utf8_unicode_ci ENGINE = InnoDB');
        $this->addSql('CREATE TABLE obj_attribute_group (id CHAR(36) NOT NULL COMMENT \'(DC2Type:uuid)\', name VARCHAR(255) NOT NULL, lower_name VARCHAR(255) NOT NULL, created DATETIME NOT NULL, updated DATETIME NOT NULL, PRIMARY KEY(id)) DEFAULT CHARACTER SET utf8 COLLATE utf8_unicode_ci ENGINE = InnoDB');
        $this->addSql('CREATE TABLE obj_type_has_attribute_group (attribute_group_id CHAR(36) NOT NULL COMMENT \'(DC2Type:uuid)\', type_id CHAR(36) NOT NULL COMMENT \'(DC2Type:uuid)\', INDEX IDX_A636F69362D643B7 (attribute_group_id), INDEX IDX_A636F693C54C8C93 (type_id), PRIMARY KEY(attribute_group_id, type_id)) DEFAULT CHARACTER SET utf8 COLLATE utf8_unicode_ci ENGINE = InnoDB');
        $this->addSql('CREATE TABLE obj_language (id VARCHAR(5) NOT NULL, name VARCHAR(255) NOT NULL, PRIMARY KEY(id)) DEFAULT CHARACTER SET utf8 COLLATE utf8_unicode_ci ENGINE = InnoDB');
        $this->addSql('CREATE TABLE obj_object (guid CHAR(36) NOT NULL COMMENT \'(DC2Type:uuid)\', parent_guid CHAR(36) DEFAULT NULL COMMENT \'(DC2Type:uuid)\', type_id CHAR(36) NOT NULL COMMENT \'(DC2Type:uuid)\', reference_id VARCHAR(255) NOT NULL, name VARCHAR(255) NOT NULL, lower_name VARCHAR(255) NOT NULL, created DATETIME NOT NULL, updated DATETIME NOT NULL, active TINYINT(1) DEFAULT \'0\' NOT NULL, UNIQUE INDEX UNIQ_3C2AB1CB1645DEA9 (reference_id), INDEX IDX_3C2AB1CB168CF906 (parent_guid), INDEX IDX_3C2AB1CBC54C8C93 (type_id), PRIMARY KEY(guid)) DEFAULT CHARACTER SET utf8 COLLATE utf8_unicode_ci ENGINE = InnoDB');
        $this->addSql('CREATE TABLE obj_object_attribute_value (id CHAR(36) NOT NULL COMMENT \'(DC2Type:uuid)\', object_guid CHAR(36) NOT NULL COMMENT \'(DC2Type:uuid)\', attribute_id CHAR(36) NOT NULL COMMENT \'(DC2Type:uuid)\', language_id VARCHAR(5) NOT NULL, value VARCHAR(255) NOT NULL, created DATETIME NOT NULL, updated DATETIME NOT NULL, INDEX IDX_128710C8B67AF3A1 (object_guid), INDEX IDX_128710C8B6E62EFA (attribute_id), INDEX IDX_128710C882F1BAF4 (language_id), PRIMARY KEY(id)) DEFAULT CHARACTER SET utf8 COLLATE utf8_unicode_ci ENGINE = InnoDB');
        $this->addSql('CREATE TABLE obj_type (id CHAR(36) NOT NULL COMMENT \'(DC2Type:uuid)\', name VARCHAR(255) NOT NULL, lower_name VARCHAR(255) NOT NULL, type_order INT UNSIGNED DEFAULT NULL, created DATETIME NOT NULL, updated DATETIME NOT NULL, PRIMARY KEY(id)) DEFAULT CHARACTER SET utf8 COLLATE utf8_unicode_ci ENGINE = InnoDB');
        $this->addSql('CREATE TABLE obj_type_mapping (identifier VARCHAR(255) NOT NULL, type_id CHAR(36) NOT NULL COMMENT \'(DC2Type:uuid)\', created DATETIME NOT NULL, updated DATETIME NOT NULL, UNIQUE INDEX UNIQ_DBAA677CC54C8C93 (type_id), PRIMARY KEY(identifier)) DEFAULT CHARACTER SET utf8 COLLATE utf8_unicode_ci ENGINE = InnoDB');
        $this->addSql('ALTER TABLE obj_attribute ADD CONSTRAINT FK_489535262D643B7 FOREIGN KEY (attribute_group_id) REFERENCES obj_attribute_group (id)');
        $this->addSql('ALTER TABLE obj_type_has_attribute_group ADD CONSTRAINT FK_A636F69362D643B7 FOREIGN KEY (attribute_group_id) REFERENCES obj_attribute_group (id)');
        $this->addSql('ALTER TABLE obj_type_has_attribute_group ADD CONSTRAINT FK_A636F693C54C8C93 FOREIGN KEY (type_id) REFERENCES obj_type (id)');
        $this->addSql('ALTER TABLE obj_object ADD CONSTRAINT FK_3C2AB1CB168CF906 FOREIGN KEY (parent_guid) REFERENCES obj_object (guid) ON DELETE CASCADE');
        $this->addSql('ALTER TABLE obj_object ADD CONSTRAINT FK_3C2AB1CBC54C8C93 FOREIGN KEY (type_id) REFERENCES obj_type (id)');
        $this->addSql('ALTER TABLE obj_object_attribute_value ADD CONSTRAINT FK_128710C8B67AF3A1 FOREIGN KEY (object_guid) REFERENCES obj_object (guid) ON DELETE CASCADE');
        $this->addSql('ALTER TABLE obj_object_attribute_value ADD CONSTRAINT FK_128710C8B6E62EFA FOREIGN KEY (attribute_id) REFERENCES obj_attribute (id)');
        $this->addSql('ALTER TABLE obj_object_attribute_value ADD CONSTRAINT FK_128710C882F1BAF4 FOREIGN KEY (language_id) REFERENCES obj_language (id)');
        $this->addSql('ALTER TABLE obj_type_mapping ADD CONSTRAINT FK_DBAA677CC54C8C93 FOREIGN KEY (type_id) REFERENCES obj_type (id)');
    }

    /**
     * @param Schema $schema
     */
    public function down(Schema $schema)
    {
        $this->skipIf($this->connection->getDatabase() !== $this->getConfiguredDatabaseName(), 'Skipped migration. Database does not match.');

        $this->abortIf($this->connection->getDatabasePlatform()->getName() != 'mysql', 'Migration can only be executed safely on \'mysql\'.');

        $this->addSql('ALTER TABLE obj_object_attribute_value DROP FOREIGN KEY FK_128710C8B6E62EFA');
        $this->addSql('ALTER TABLE obj_attribute DROP FOREIGN KEY FK_489535262D643B7');
        $this->addSql('ALTER TABLE obj_type_has_attribute_group DROP FOREIGN KEY FK_A636F69362D643B7');
        $this->addSql('ALTER TABLE obj_object_attribute_value DROP FOREIGN KEY FK_128710C882F1BAF4');
        $this->addSql('ALTER TABLE obj_object DROP FOREIGN KEY FK_3C2AB1CB168CF906');
        $this->addSql('ALTER TABLE obj_object_attribute_value DROP FOREIGN KEY FK_128710C8B67AF3A1');
        $this->addSql('ALTER TABLE obj_type_has_attribute_group DROP FOREIGN KEY FK_A636F693C54C8C93');
        $this->addSql('ALTER TABLE obj_object DROP FOREIGN KEY FK_3C2AB1CBC54C8C93');
        $this->addSql('ALTER TABLE obj_type_mapping DROP FOREIGN KEY FK_DBAA677CC54C8C93');
        $this->addSql('DROP TABLE obj_attribute');
        $this->addSql('DROP TABLE obj_attribute_group');
        $this->addSql('DROP TABLE obj_type_has_attribute_group');
        $this->addSql('DROP TABLE obj_language');
        $this->addSql('DROP TABLE obj_object');
        $this->addSql('DROP TABLE obj_object_attribute_value');
        $this->addSql('DROP TABLE obj_type');
        $this->addSql('DROP TABLE obj_type_mapping');
    }

    /**
     * Sets the container.
     *
     * @param ContainerInterface|null $container A ContainerInterface instance or null
     */
    public function setContainer(ContainerInterface $container = null)
    {
        $this->container = $container;
    }

    /**
     * @return string
     */
    private function getConfiguredDatabaseName()
    {
        return $this->container->getParameter('database_webservice_name');
    }
}
