/*
 Navicat MySQL Data Transfer

 Source Server         : localhost
 Source Server Type    : MySQL
 Source Server Version : 50719
 Source Host           : localhost:3306
 Source Schema         : ls-sso-ows

 Target Server Type    : MySQL
 Target Server Version : 50719
 File Encoding         : 65001

 Date: 15/01/2018 13:37:53
*/

SET NAMES utf8mb4;
SET FOREIGN_KEY_CHECKS = 0;

-- ----------------------------
-- Table structure for backend_session
-- ----------------------------
DROP TABLE IF EXISTS `backend_session`;
CREATE TABLE `backend_session` (
  `session_id` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  `session_value` blob NOT NULL,
  `session_time` int(11) NOT NULL,
  `session_lifetime` bigint(20) NOT NULL,
  PRIMARY KEY (`session_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

-- ----------------------------
-- Records of backend_session
-- ----------------------------
BEGIN;
INSERT INTO `backend_session` VALUES ('3e752a894198168ce025080485fb48eb', 0x5F7366325F617474726962757465737C613A313A7B733A31383A225F637372662F61757468656E746963617465223B733A34333A224F784B4E6D67786F4E6F46727039424C68334E716A4F55532D74482D31635A41315353564C35777050334D223B7D5F7366325F666C61736865737C613A303A7B7D5F7366325F6D6574617C613A333A7B733A313A2275223B693A313531363031383732393B733A313A2263223B693A313531363031383732373B733A313A226C223B733A313A2230223B7D, 1516018729, 1440);
COMMIT;

-- ----------------------------
-- Table structure for backend_user
-- ----------------------------
DROP TABLE IF EXISTS `backend_user`;
CREATE TABLE `backend_user` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `username` varchar(180) COLLATE utf8_unicode_ci NOT NULL,
  `username_canonical` varchar(180) COLLATE utf8_unicode_ci NOT NULL,
  `email` varchar(180) COLLATE utf8_unicode_ci NOT NULL,
  `email_canonical` varchar(180) COLLATE utf8_unicode_ci NOT NULL,
  `enabled` tinyint(1) NOT NULL,
  `salt` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `password` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  `last_login` datetime DEFAULT NULL,
  `confirmation_token` varchar(180) COLLATE utf8_unicode_ci DEFAULT NULL,
  `password_requested_at` datetime DEFAULT NULL,
  `roles` longtext COLLATE utf8_unicode_ci NOT NULL COMMENT '(DC2Type:array)',
  `firstname` varchar(127) COLLATE utf8_unicode_ci DEFAULT NULL,
  `lastname` varchar(127) COLLATE utf8_unicode_ci DEFAULT NULL,
  `organisation` varchar(127) COLLATE utf8_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `UNIQ_C73586E92FC23A8` (`username_canonical`),
  UNIQUE KEY `UNIQ_C73586EA0D96FBF` (`email_canonical`),
  UNIQUE KEY `UNIQ_C73586EC05FB297` (`confirmation_token`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

-- ----------------------------
-- Records of backend_user
-- ----------------------------
BEGIN;
INSERT INTO `backend_user` VALUES (1, 'admin', 'admin', 'sb@life-style.de', 'sb@life-style.de', 1, '0NzXY758djDjq2FSN.60ST.Gc.NL79pSQV9TdpSHO7A', 'egOVJ6Tc5YZLRbtUhUeeBtWlfxusgKzJo6ZYBRiLI+FYJaaJNpJeu/9pZyFMmYkVw9L0rXw/7JhwZ/laxHLRcA==', '2018-01-15 10:21:45', NULL, NULL, 'a:1:{i:0;s:16:\"ROLE_SUPER_ADMIN\";}', NULL, NULL, NULL);
COMMIT;

-- ----------------------------
-- Table structure for obj_attribute
-- ----------------------------
DROP TABLE IF EXISTS `obj_attribute`;
CREATE TABLE `obj_attribute` (
  `id` char(36) COLLATE utf8_unicode_ci NOT NULL COMMENT '(DC2Type:uuid)',
  `attribute_group_id` char(36) COLLATE utf8_unicode_ci NOT NULL COMMENT '(DC2Type:uuid)',
  `name` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  `lower_name` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  `mandatory` tinyint(1) NOT NULL DEFAULT '0',
  `possible_values` longtext COLLATE utf8_unicode_ci COMMENT '(DC2Type:array)',
  `default_value` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `translatable` tinyint(1) NOT NULL DEFAULT '0',
  `created` datetime NOT NULL,
  `updated` datetime NOT NULL,
  PRIMARY KEY (`id`),
  KEY `IDX_489535262D643B7` (`attribute_group_id`),
  CONSTRAINT `FK_489535262D643B7` FOREIGN KEY (`attribute_group_id`) REFERENCES `obj_attribute_group` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

-- ----------------------------
-- Records of obj_attribute
-- ----------------------------
BEGIN;
INSERT INTO `obj_attribute` VALUES ('056dd366-8a17-4ca2-87a3-26f102331cf6', 'e519d7b1-9177-48d6-a0b5-f4a1901a8519', 'Description', 'description', 0, 'a:0:{}', NULL, 0, '2018-01-15 08:47:09', '2018-01-15 08:47:09');
INSERT INTO `obj_attribute` VALUES ('0c016c60-04ce-4a08-a128-e214e790cb1f', 'e519d7b1-9177-48d6-a0b5-f4a1901a8519', 'Crew', 'crew', 0, 'a:0:{}', NULL, 0, '2018-01-15 08:46:45', '2018-01-15 08:46:45');
INSERT INTO `obj_attribute` VALUES ('40eb7a5b-fcd2-469c-ac56-b2caacfb4327', '18c2ed9b-51e5-4590-b5d5-23c75375ed1a', 'Cross-section dimension', 'cross-section dimension', 0, 'a:0:{}', NULL, 0, '2018-01-15 08:50:27', '2018-01-15 09:26:51');
INSERT INTO `obj_attribute` VALUES ('43831baa-03b1-418d-b638-857054ff69b6', '2fa9c7cf-4d52-4139-a3a9-713b6d5e7037', 'Arms', 'arms', 0, 'a:0:{}', NULL, 0, '2018-01-15 08:47:50', '2018-01-15 09:26:17');
INSERT INTO `obj_attribute` VALUES ('9776f008-3e7f-4b77-97b7-0b9b79232d6e', '2fa9c7cf-4d52-4139-a3a9-713b6d5e7037', 'Speed', 'speed', 0, 'a:0:{}', NULL, 0, '2018-01-15 08:48:46', '2018-01-15 09:26:04');
INSERT INTO `obj_attribute` VALUES ('b00a97ba-5947-4da8-a7ed-84d2bbbc8086', '18c2ed9b-51e5-4590-b5d5-23c75375ed1a', 'Living quators', 'living quators', 0, 'a:0:{}', NULL, 0, '2018-01-15 08:49:30', '2018-01-15 09:26:35');
INSERT INTO `obj_attribute` VALUES ('b1c16a8b-d5d7-4f4e-bd3d-4906aa9a4d6d', 'e519d7b1-9177-48d6-a0b5-f4a1901a8519', 'Universe', 'universe', 0, 'a:3:{i:0;s:9:\"Star Trek\";i:1;s:9:\"Star Wars\";i:2;s:10:\"Real World\";}', NULL, 0, '2018-01-15 08:51:15', '2018-01-15 09:28:36');
COMMIT;

-- ----------------------------
-- Table structure for obj_attribute_group
-- ----------------------------
DROP TABLE IF EXISTS `obj_attribute_group`;
CREATE TABLE `obj_attribute_group` (
  `id` char(36) COLLATE utf8_unicode_ci NOT NULL COMMENT '(DC2Type:uuid)',
  `name` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  `lower_name` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  `created` datetime NOT NULL,
  `updated` datetime NOT NULL,
  PRIMARY KEY (`id`),
  KEY `name_idx` (`name`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

-- ----------------------------
-- Records of obj_attribute_group
-- ----------------------------
BEGIN;
INSERT INTO `obj_attribute_group` VALUES ('18c2ed9b-51e5-4590-b5d5-23c75375ed1a', 'SpaceStationsAttibutes', 'spacestationsattibutes', '2018-01-15 08:44:55', '2018-01-15 08:44:55');
INSERT INTO `obj_attribute_group` VALUES ('2fa9c7cf-4d52-4139-a3a9-713b6d5e7037', 'StarShipsAttributes', 'starshipsattributes', '2018-01-15 08:44:28', '2018-01-15 08:44:28');
INSERT INTO `obj_attribute_group` VALUES ('e519d7b1-9177-48d6-a0b5-f4a1901a8519', 'CommonAttributes', 'commonattributes', '2018-01-15 08:45:19', '2018-01-15 08:45:19');
COMMIT;

-- ----------------------------
-- Table structure for obj_language
-- ----------------------------
DROP TABLE IF EXISTS `obj_language`;
CREATE TABLE `obj_language` (
  `id` varchar(5) COLLATE utf8_unicode_ci NOT NULL,
  `name` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

-- ----------------------------
-- Records of obj_language
-- ----------------------------
BEGIN;
INSERT INTO `obj_language` VALUES ('aa', 'Afar');
INSERT INTO `obj_language` VALUES ('ab', 'Abkhazian');
INSERT INTO `obj_language` VALUES ('ace', 'Achinese');
INSERT INTO `obj_language` VALUES ('ach', 'Acoli');
INSERT INTO `obj_language` VALUES ('ada', 'Adangme');
INSERT INTO `obj_language` VALUES ('ady', 'Adyghe');
INSERT INTO `obj_language` VALUES ('ae', 'Avestan');
INSERT INTO `obj_language` VALUES ('af', 'Afrikaans');
INSERT INTO `obj_language` VALUES ('afh', 'Afrihili');
INSERT INTO `obj_language` VALUES ('agq', 'Aghem');
INSERT INTO `obj_language` VALUES ('ain', 'Ainu');
INSERT INTO `obj_language` VALUES ('ak', 'Akan');
INSERT INTO `obj_language` VALUES ('akk', 'Akkadian');
INSERT INTO `obj_language` VALUES ('akz', 'Alabama');
INSERT INTO `obj_language` VALUES ('ale', 'Aleut');
INSERT INTO `obj_language` VALUES ('all', 'NotSet');
INSERT INTO `obj_language` VALUES ('aln', 'Gheg Albanian');
INSERT INTO `obj_language` VALUES ('alt', 'Southern Altai');
INSERT INTO `obj_language` VALUES ('am', 'Amharic');
INSERT INTO `obj_language` VALUES ('an', 'Aragonese');
INSERT INTO `obj_language` VALUES ('ang', 'Old English');
INSERT INTO `obj_language` VALUES ('anp', 'Angika');
INSERT INTO `obj_language` VALUES ('ar', 'Arabic');
INSERT INTO `obj_language` VALUES ('ar_00', 'Modern Standard Arabic');
INSERT INTO `obj_language` VALUES ('arc', 'Aramaic');
INSERT INTO `obj_language` VALUES ('arn', 'Mapuche');
INSERT INTO `obj_language` VALUES ('aro', 'Araona');
INSERT INTO `obj_language` VALUES ('arp', 'Arapaho');
INSERT INTO `obj_language` VALUES ('arq', 'Algerian Arabic');
INSERT INTO `obj_language` VALUES ('ars', 'Najdi Arabic');
INSERT INTO `obj_language` VALUES ('arw', 'Arawak');
INSERT INTO `obj_language` VALUES ('ary', 'Moroccan Arabic');
INSERT INTO `obj_language` VALUES ('arz', 'Egyptian Arabic');
INSERT INTO `obj_language` VALUES ('as', 'Assamese');
INSERT INTO `obj_language` VALUES ('asa', 'Asu');
INSERT INTO `obj_language` VALUES ('ase', 'American Sign Language');
INSERT INTO `obj_language` VALUES ('ast', 'Asturian');
INSERT INTO `obj_language` VALUES ('av', 'Avaric');
INSERT INTO `obj_language` VALUES ('avk', 'Kotava');
INSERT INTO `obj_language` VALUES ('awa', 'Awadhi');
INSERT INTO `obj_language` VALUES ('ay', 'Aymara');
INSERT INTO `obj_language` VALUES ('az', 'Azerbaijani');
INSERT INTO `obj_language` VALUES ('ba', 'Bashkir');
INSERT INTO `obj_language` VALUES ('bal', 'Baluchi');
INSERT INTO `obj_language` VALUES ('ban', 'Balinese');
INSERT INTO `obj_language` VALUES ('bar', 'Bavarian');
INSERT INTO `obj_language` VALUES ('bas', 'Basaa');
INSERT INTO `obj_language` VALUES ('bax', 'Bamun');
INSERT INTO `obj_language` VALUES ('bbc', 'Batak Toba');
INSERT INTO `obj_language` VALUES ('bbj', 'Ghomala');
INSERT INTO `obj_language` VALUES ('be', 'Belarusian');
INSERT INTO `obj_language` VALUES ('bej', 'Beja');
INSERT INTO `obj_language` VALUES ('bem', 'Bemba');
INSERT INTO `obj_language` VALUES ('bew', 'Betawi');
INSERT INTO `obj_language` VALUES ('bez', 'Bena');
INSERT INTO `obj_language` VALUES ('bfd', 'Bafut');
INSERT INTO `obj_language` VALUES ('bfq', 'Badaga');
INSERT INTO `obj_language` VALUES ('bg', 'Bulgarian');
INSERT INTO `obj_language` VALUES ('bho', 'Bhojpuri');
INSERT INTO `obj_language` VALUES ('bi', 'Bislama');
INSERT INTO `obj_language` VALUES ('bik', 'Bikol');
INSERT INTO `obj_language` VALUES ('bin', 'Bini');
INSERT INTO `obj_language` VALUES ('bjn', 'Banjar');
INSERT INTO `obj_language` VALUES ('bkm', 'Kom');
INSERT INTO `obj_language` VALUES ('bla', 'Siksika');
INSERT INTO `obj_language` VALUES ('bm', 'Bambara');
INSERT INTO `obj_language` VALUES ('bn', 'Bangla');
INSERT INTO `obj_language` VALUES ('bo', 'Tibetan');
INSERT INTO `obj_language` VALUES ('bpy', 'Bishnupriya');
INSERT INTO `obj_language` VALUES ('bqi', 'Bakhtiari');
INSERT INTO `obj_language` VALUES ('br', 'Breton');
INSERT INTO `obj_language` VALUES ('bra', 'Braj');
INSERT INTO `obj_language` VALUES ('brh', 'Brahui');
INSERT INTO `obj_language` VALUES ('brx', 'Bodo');
INSERT INTO `obj_language` VALUES ('bs', 'Bosnian');
INSERT INTO `obj_language` VALUES ('bss', 'Akoose');
INSERT INTO `obj_language` VALUES ('bua', 'Buriat');
INSERT INTO `obj_language` VALUES ('bug', 'Buginese');
INSERT INTO `obj_language` VALUES ('bum', 'Bulu');
INSERT INTO `obj_language` VALUES ('byn', 'Blin');
INSERT INTO `obj_language` VALUES ('byv', 'Medumba');
INSERT INTO `obj_language` VALUES ('ca', 'Catalan');
INSERT INTO `obj_language` VALUES ('cad', 'Caddo');
INSERT INTO `obj_language` VALUES ('car', 'Carib');
INSERT INTO `obj_language` VALUES ('cay', 'Cayuga');
INSERT INTO `obj_language` VALUES ('cch', 'Atsam');
INSERT INTO `obj_language` VALUES ('ccp', 'Chakma');
INSERT INTO `obj_language` VALUES ('ce', 'Chechen');
INSERT INTO `obj_language` VALUES ('ceb', 'Cebuano');
INSERT INTO `obj_language` VALUES ('cgg', 'Chiga');
INSERT INTO `obj_language` VALUES ('ch', 'Chamorro');
INSERT INTO `obj_language` VALUES ('chb', 'Chibcha');
INSERT INTO `obj_language` VALUES ('chg', 'Chagatai');
INSERT INTO `obj_language` VALUES ('chk', 'Chuukese');
INSERT INTO `obj_language` VALUES ('chm', 'Mari');
INSERT INTO `obj_language` VALUES ('chn', 'Chinook Jargon');
INSERT INTO `obj_language` VALUES ('cho', 'Choctaw');
INSERT INTO `obj_language` VALUES ('chp', 'Chipewyan');
INSERT INTO `obj_language` VALUES ('chr', 'Cherokee');
INSERT INTO `obj_language` VALUES ('chy', 'Cheyenne');
INSERT INTO `obj_language` VALUES ('ckb', 'Central Kurdish');
INSERT INTO `obj_language` VALUES ('co', 'Corsican');
INSERT INTO `obj_language` VALUES ('cop', 'Coptic');
INSERT INTO `obj_language` VALUES ('cps', 'Capiznon');
INSERT INTO `obj_language` VALUES ('cr', 'Cree');
INSERT INTO `obj_language` VALUES ('crh', 'Crimean Turkish');
INSERT INTO `obj_language` VALUES ('crs', 'Seselwa Creole French');
INSERT INTO `obj_language` VALUES ('cs', 'Czech');
INSERT INTO `obj_language` VALUES ('csb', 'Kashubian');
INSERT INTO `obj_language` VALUES ('cu', 'Church Slavic');
INSERT INTO `obj_language` VALUES ('cv', 'Chuvash');
INSERT INTO `obj_language` VALUES ('da', 'Danish');
INSERT INTO `obj_language` VALUES ('dak', 'Dakota');
INSERT INTO `obj_language` VALUES ('dar', 'Dargwa');
INSERT INTO `obj_language` VALUES ('dav', 'Taita');
INSERT INTO `obj_language` VALUES ('de', 'German');
INSERT INTO `obj_language` VALUES ('de_AT', 'Austrian German');
INSERT INTO `obj_language` VALUES ('de_CH', 'Swiss High German');
INSERT INTO `obj_language` VALUES ('del', 'Delaware');
INSERT INTO `obj_language` VALUES ('den', 'Slave');
INSERT INTO `obj_language` VALUES ('dgr', 'Dogrib');
INSERT INTO `obj_language` VALUES ('din', 'Dinka');
INSERT INTO `obj_language` VALUES ('doi', 'Dogri');
INSERT INTO `obj_language` VALUES ('dsb', 'Lower Sorbian');
INSERT INTO `obj_language` VALUES ('dtp', 'Central Dusun');
INSERT INTO `obj_language` VALUES ('dua', 'Duala');
INSERT INTO `obj_language` VALUES ('dum', 'Middle Dutch');
INSERT INTO `obj_language` VALUES ('dv', 'Divehi');
INSERT INTO `obj_language` VALUES ('dyo', 'Jola-Fonyi');
INSERT INTO `obj_language` VALUES ('dyu', 'Dyula');
INSERT INTO `obj_language` VALUES ('dz', 'Dzongkha');
INSERT INTO `obj_language` VALUES ('dzg', 'Dazaga');
INSERT INTO `obj_language` VALUES ('ebu', 'Embu');
INSERT INTO `obj_language` VALUES ('ee', 'Ewe');
INSERT INTO `obj_language` VALUES ('efi', 'Efik');
INSERT INTO `obj_language` VALUES ('egl', 'Emilian');
INSERT INTO `obj_language` VALUES ('egy', 'Ancient Egyptian');
INSERT INTO `obj_language` VALUES ('eka', 'Ekajuk');
INSERT INTO `obj_language` VALUES ('el', 'Greek');
INSERT INTO `obj_language` VALUES ('elx', 'Elamite');
INSERT INTO `obj_language` VALUES ('en', 'English');
INSERT INTO `obj_language` VALUES ('en_AU', 'Australian English');
INSERT INTO `obj_language` VALUES ('en_CA', 'Canadian English');
INSERT INTO `obj_language` VALUES ('en_GB', 'British English');
INSERT INTO `obj_language` VALUES ('en_US', 'American English');
INSERT INTO `obj_language` VALUES ('enm', 'Middle English');
INSERT INTO `obj_language` VALUES ('eo', 'Esperanto');
INSERT INTO `obj_language` VALUES ('es', 'Spanish');
INSERT INTO `obj_language` VALUES ('es_41', 'Latin American Spanish');
INSERT INTO `obj_language` VALUES ('es_ES', 'European Spanish');
INSERT INTO `obj_language` VALUES ('es_MX', 'Mexican Spanish');
INSERT INTO `obj_language` VALUES ('esu', 'Central Yupik');
INSERT INTO `obj_language` VALUES ('et', 'Estonian');
INSERT INTO `obj_language` VALUES ('eu', 'Basque');
INSERT INTO `obj_language` VALUES ('ewo', 'Ewondo');
INSERT INTO `obj_language` VALUES ('ext', 'Extremaduran');
INSERT INTO `obj_language` VALUES ('fa', 'Persian');
INSERT INTO `obj_language` VALUES ('fa_AF', 'Dari');
INSERT INTO `obj_language` VALUES ('fan', 'Fang');
INSERT INTO `obj_language` VALUES ('fat', 'Fanti');
INSERT INTO `obj_language` VALUES ('ff', 'Fulah');
INSERT INTO `obj_language` VALUES ('fi', 'Finnish');
INSERT INTO `obj_language` VALUES ('fil', 'Filipino');
INSERT INTO `obj_language` VALUES ('fit', 'Tornedalen Finnish');
INSERT INTO `obj_language` VALUES ('fj', 'Fijian');
INSERT INTO `obj_language` VALUES ('fo', 'Faroese');
INSERT INTO `obj_language` VALUES ('fon', 'Fon');
INSERT INTO `obj_language` VALUES ('fr', 'French');
INSERT INTO `obj_language` VALUES ('fr_CA', 'Canadian French');
INSERT INTO `obj_language` VALUES ('fr_CH', 'Swiss French');
INSERT INTO `obj_language` VALUES ('frc', 'Cajun French');
INSERT INTO `obj_language` VALUES ('frm', 'Middle French');
INSERT INTO `obj_language` VALUES ('fro', 'Old French');
INSERT INTO `obj_language` VALUES ('frp', 'Arpitan');
INSERT INTO `obj_language` VALUES ('frr', 'Northern Frisian');
INSERT INTO `obj_language` VALUES ('frs', 'Eastern Frisian');
INSERT INTO `obj_language` VALUES ('fur', 'Friulian');
INSERT INTO `obj_language` VALUES ('ga', 'Irish');
INSERT INTO `obj_language` VALUES ('gaa', 'Ga');
INSERT INTO `obj_language` VALUES ('gag', 'Gagauz');
INSERT INTO `obj_language` VALUES ('gan', 'Gan Chinese');
INSERT INTO `obj_language` VALUES ('gay', 'Gayo');
INSERT INTO `obj_language` VALUES ('gba', 'Gbaya');
INSERT INTO `obj_language` VALUES ('gd', 'Scottish Gaelic');
INSERT INTO `obj_language` VALUES ('gez', 'Geez');
INSERT INTO `obj_language` VALUES ('gil', 'Gilbertese');
INSERT INTO `obj_language` VALUES ('gl', 'Galician');
INSERT INTO `obj_language` VALUES ('glk', 'Gilaki');
INSERT INTO `obj_language` VALUES ('gmh', 'Middle High German');
INSERT INTO `obj_language` VALUES ('gn', 'Guarani');
INSERT INTO `obj_language` VALUES ('goh', 'Old High German');
INSERT INTO `obj_language` VALUES ('gom', 'Goan Konkani');
INSERT INTO `obj_language` VALUES ('gon', 'Gondi');
INSERT INTO `obj_language` VALUES ('gor', 'Gorontalo');
INSERT INTO `obj_language` VALUES ('got', 'Gothic');
INSERT INTO `obj_language` VALUES ('grb', 'Grebo');
INSERT INTO `obj_language` VALUES ('grc', 'Ancient Greek');
INSERT INTO `obj_language` VALUES ('gsw', 'Swiss German');
INSERT INTO `obj_language` VALUES ('gu', 'Gujarati');
INSERT INTO `obj_language` VALUES ('gur', 'Frafra');
INSERT INTO `obj_language` VALUES ('guz', 'Gusii');
INSERT INTO `obj_language` VALUES ('gv', 'Manx');
INSERT INTO `obj_language` VALUES ('gwi', 'Gwichʼin');
INSERT INTO `obj_language` VALUES ('ha', 'Hausa');
INSERT INTO `obj_language` VALUES ('hai', 'Haida');
INSERT INTO `obj_language` VALUES ('hak', 'Hakka Chinese');
INSERT INTO `obj_language` VALUES ('haw', 'Hawaiian');
INSERT INTO `obj_language` VALUES ('he', 'Hebrew');
INSERT INTO `obj_language` VALUES ('hi', 'Hindi');
INSERT INTO `obj_language` VALUES ('hif', 'Fiji Hindi');
INSERT INTO `obj_language` VALUES ('hil', 'Hiligaynon');
INSERT INTO `obj_language` VALUES ('hit', 'Hittite');
INSERT INTO `obj_language` VALUES ('hmn', 'Hmong');
INSERT INTO `obj_language` VALUES ('ho', 'Hiri Motu');
INSERT INTO `obj_language` VALUES ('hr', 'Croatian');
INSERT INTO `obj_language` VALUES ('ht', 'Haitian Creole');
INSERT INTO `obj_language` VALUES ('hu', 'Hungarian');
INSERT INTO `obj_language` VALUES ('hup', 'Hupa');
INSERT INTO `obj_language` VALUES ('hy', 'Armenian');
INSERT INTO `obj_language` VALUES ('hz', 'Herero');
INSERT INTO `obj_language` VALUES ('ia', 'Interlingua');
INSERT INTO `obj_language` VALUES ('iba', 'Iban');
INSERT INTO `obj_language` VALUES ('ibb', 'Ibibio');
INSERT INTO `obj_language` VALUES ('id', 'Indonesian');
INSERT INTO `obj_language` VALUES ('ie', 'Interlingue');
INSERT INTO `obj_language` VALUES ('ig', 'Igbo');
INSERT INTO `obj_language` VALUES ('ii', 'Sichuan Yi');
INSERT INTO `obj_language` VALUES ('ik', 'Inupiaq');
INSERT INTO `obj_language` VALUES ('ilo', 'Iloko');
INSERT INTO `obj_language` VALUES ('inh', 'Ingush');
INSERT INTO `obj_language` VALUES ('io', 'Ido');
INSERT INTO `obj_language` VALUES ('is', 'Icelandic');
INSERT INTO `obj_language` VALUES ('it', 'Italian');
INSERT INTO `obj_language` VALUES ('iu', 'Inuktitut');
INSERT INTO `obj_language` VALUES ('izh', 'Ingrian');
INSERT INTO `obj_language` VALUES ('ja', 'Japanese');
INSERT INTO `obj_language` VALUES ('jam', 'Jamaican Creole English');
INSERT INTO `obj_language` VALUES ('jbo', 'Lojban');
INSERT INTO `obj_language` VALUES ('jgo', 'Ngomba');
INSERT INTO `obj_language` VALUES ('jmc', 'Machame');
INSERT INTO `obj_language` VALUES ('jpr', 'Judeo-Persian');
INSERT INTO `obj_language` VALUES ('jrb', 'Judeo-Arabic');
INSERT INTO `obj_language` VALUES ('jut', 'Jutish');
INSERT INTO `obj_language` VALUES ('jv', 'Javanese');
INSERT INTO `obj_language` VALUES ('ka', 'Georgian');
INSERT INTO `obj_language` VALUES ('kaa', 'Kara-Kalpak');
INSERT INTO `obj_language` VALUES ('kab', 'Kabyle');
INSERT INTO `obj_language` VALUES ('kac', 'Kachin');
INSERT INTO `obj_language` VALUES ('kaj', 'Jju');
INSERT INTO `obj_language` VALUES ('kam', 'Kamba');
INSERT INTO `obj_language` VALUES ('kaw', 'Kawi');
INSERT INTO `obj_language` VALUES ('kbd', 'Kabardian');
INSERT INTO `obj_language` VALUES ('kbl', 'Kanembu');
INSERT INTO `obj_language` VALUES ('kde', 'Makonde');
INSERT INTO `obj_language` VALUES ('kea', 'Kabuverdianu');
INSERT INTO `obj_language` VALUES ('ken', 'Kenyang');
INSERT INTO `obj_language` VALUES ('kfo', 'Koro');
INSERT INTO `obj_language` VALUES ('kg', 'Kongo');
INSERT INTO `obj_language` VALUES ('kgp', 'Kaingang');
INSERT INTO `obj_language` VALUES ('kha', 'Khasi');
INSERT INTO `obj_language` VALUES ('kho', 'Khotanese');
INSERT INTO `obj_language` VALUES ('khq', 'Koyra Chiini');
INSERT INTO `obj_language` VALUES ('khw', 'Khowar');
INSERT INTO `obj_language` VALUES ('ki', 'Kikuyu');
INSERT INTO `obj_language` VALUES ('kiu', 'Kirmanjki');
INSERT INTO `obj_language` VALUES ('kj', 'Kuanyama');
INSERT INTO `obj_language` VALUES ('kk', 'Kazakh');
INSERT INTO `obj_language` VALUES ('kkj', 'Kako');
INSERT INTO `obj_language` VALUES ('kl', 'Kalaallisut');
INSERT INTO `obj_language` VALUES ('kln', 'Kalenjin');
INSERT INTO `obj_language` VALUES ('km', 'Khmer');
INSERT INTO `obj_language` VALUES ('kmb', 'Kimbundu');
INSERT INTO `obj_language` VALUES ('kn', 'Kannada');
INSERT INTO `obj_language` VALUES ('ko', 'Korean');
INSERT INTO `obj_language` VALUES ('koi', 'Komi-Permyak');
INSERT INTO `obj_language` VALUES ('kok', 'Konkani');
INSERT INTO `obj_language` VALUES ('kos', 'Kosraean');
INSERT INTO `obj_language` VALUES ('kpe', 'Kpelle');
INSERT INTO `obj_language` VALUES ('kr', 'Kanuri');
INSERT INTO `obj_language` VALUES ('krc', 'Karachay-Balkar');
INSERT INTO `obj_language` VALUES ('kri', 'Krio');
INSERT INTO `obj_language` VALUES ('krj', 'Kinaray-a');
INSERT INTO `obj_language` VALUES ('krl', 'Karelian');
INSERT INTO `obj_language` VALUES ('kru', 'Kurukh');
INSERT INTO `obj_language` VALUES ('ks', 'Kashmiri');
INSERT INTO `obj_language` VALUES ('ksb', 'Shambala');
INSERT INTO `obj_language` VALUES ('ksf', 'Bafia');
INSERT INTO `obj_language` VALUES ('ksh', 'Colognian');
INSERT INTO `obj_language` VALUES ('ku', 'Kurdish');
INSERT INTO `obj_language` VALUES ('kum', 'Kumyk');
INSERT INTO `obj_language` VALUES ('kut', 'Kutenai');
INSERT INTO `obj_language` VALUES ('kv', 'Komi');
INSERT INTO `obj_language` VALUES ('kw', 'Cornish');
INSERT INTO `obj_language` VALUES ('ky', 'Kyrgyz');
INSERT INTO `obj_language` VALUES ('la', 'Latin');
INSERT INTO `obj_language` VALUES ('lad', 'Ladino');
INSERT INTO `obj_language` VALUES ('lag', 'Langi');
INSERT INTO `obj_language` VALUES ('lah', 'Lahnda');
INSERT INTO `obj_language` VALUES ('lam', 'Lamba');
INSERT INTO `obj_language` VALUES ('lb', 'Luxembourgish');
INSERT INTO `obj_language` VALUES ('lez', 'Lezghian');
INSERT INTO `obj_language` VALUES ('lfn', 'Lingua Franca Nova');
INSERT INTO `obj_language` VALUES ('lg', 'Ganda');
INSERT INTO `obj_language` VALUES ('li', 'Limburgish');
INSERT INTO `obj_language` VALUES ('lij', 'Ligurian');
INSERT INTO `obj_language` VALUES ('liv', 'Livonian');
INSERT INTO `obj_language` VALUES ('lkt', 'Lakota');
INSERT INTO `obj_language` VALUES ('lmo', 'Lombard');
INSERT INTO `obj_language` VALUES ('ln', 'Lingala');
INSERT INTO `obj_language` VALUES ('lo', 'Lao');
INSERT INTO `obj_language` VALUES ('lol', 'Mongo');
INSERT INTO `obj_language` VALUES ('lou', 'Louisiana Creole');
INSERT INTO `obj_language` VALUES ('loz', 'Lozi');
INSERT INTO `obj_language` VALUES ('lrc', 'Northern Luri');
INSERT INTO `obj_language` VALUES ('lt', 'Lithuanian');
INSERT INTO `obj_language` VALUES ('ltg', 'Latgalian');
INSERT INTO `obj_language` VALUES ('lu', 'Luba-Katanga');
INSERT INTO `obj_language` VALUES ('lua', 'Luba-Lulua');
INSERT INTO `obj_language` VALUES ('lui', 'Luiseno');
INSERT INTO `obj_language` VALUES ('lun', 'Lunda');
INSERT INTO `obj_language` VALUES ('luo', 'Luo');
INSERT INTO `obj_language` VALUES ('lus', 'Mizo');
INSERT INTO `obj_language` VALUES ('luy', 'Luyia');
INSERT INTO `obj_language` VALUES ('lv', 'Latvian');
INSERT INTO `obj_language` VALUES ('lzh', 'Literary Chinese');
INSERT INTO `obj_language` VALUES ('lzz', 'Laz');
INSERT INTO `obj_language` VALUES ('mad', 'Madurese');
INSERT INTO `obj_language` VALUES ('maf', 'Mafa');
INSERT INTO `obj_language` VALUES ('mag', 'Magahi');
INSERT INTO `obj_language` VALUES ('mai', 'Maithili');
INSERT INTO `obj_language` VALUES ('mak', 'Makasar');
INSERT INTO `obj_language` VALUES ('man', 'Mandingo');
INSERT INTO `obj_language` VALUES ('mas', 'Masai');
INSERT INTO `obj_language` VALUES ('mde', 'Maba');
INSERT INTO `obj_language` VALUES ('mdf', 'Moksha');
INSERT INTO `obj_language` VALUES ('mdr', 'Mandar');
INSERT INTO `obj_language` VALUES ('men', 'Mende');
INSERT INTO `obj_language` VALUES ('mer', 'Meru');
INSERT INTO `obj_language` VALUES ('mfe', 'Morisyen');
INSERT INTO `obj_language` VALUES ('mg', 'Malagasy');
INSERT INTO `obj_language` VALUES ('mga', 'Middle Irish');
INSERT INTO `obj_language` VALUES ('mgh', 'Makhuwa-Meetto');
INSERT INTO `obj_language` VALUES ('mgo', 'Metaʼ');
INSERT INTO `obj_language` VALUES ('mh', 'Marshallese');
INSERT INTO `obj_language` VALUES ('mi', 'Maori');
INSERT INTO `obj_language` VALUES ('mic', 'Mi\'kmaq');
INSERT INTO `obj_language` VALUES ('min', 'Minangkabau');
INSERT INTO `obj_language` VALUES ('mk', 'Macedonian');
INSERT INTO `obj_language` VALUES ('ml', 'Malayalam');
INSERT INTO `obj_language` VALUES ('mn', 'Mongolian');
INSERT INTO `obj_language` VALUES ('mnc', 'Manchu');
INSERT INTO `obj_language` VALUES ('mni', 'Manipuri');
INSERT INTO `obj_language` VALUES ('moh', 'Mohawk');
INSERT INTO `obj_language` VALUES ('mos', 'Mossi');
INSERT INTO `obj_language` VALUES ('mr', 'Marathi');
INSERT INTO `obj_language` VALUES ('ms', 'Malay');
INSERT INTO `obj_language` VALUES ('mt', 'Maltese');
INSERT INTO `obj_language` VALUES ('mua', 'Mundang');
INSERT INTO `obj_language` VALUES ('mul', 'Multiple languages');
INSERT INTO `obj_language` VALUES ('mus', 'Creek');
INSERT INTO `obj_language` VALUES ('mwl', 'Mirandese');
INSERT INTO `obj_language` VALUES ('mwr', 'Marwari');
INSERT INTO `obj_language` VALUES ('mwv', 'Mentawai');
INSERT INTO `obj_language` VALUES ('my', 'Burmese');
INSERT INTO `obj_language` VALUES ('mye', 'Myene');
INSERT INTO `obj_language` VALUES ('myv', 'Erzya');
INSERT INTO `obj_language` VALUES ('mzn', 'Mazanderani');
INSERT INTO `obj_language` VALUES ('na', 'Nauru');
INSERT INTO `obj_language` VALUES ('nan', 'Min Nan Chinese');
INSERT INTO `obj_language` VALUES ('nap', 'Neapolitan');
INSERT INTO `obj_language` VALUES ('naq', 'Nama');
INSERT INTO `obj_language` VALUES ('nb', 'Norwegian Bokmål');
INSERT INTO `obj_language` VALUES ('nd', 'North Ndebele');
INSERT INTO `obj_language` VALUES ('nds', 'Low German');
INSERT INTO `obj_language` VALUES ('nds_N', 'Low Saxon');
INSERT INTO `obj_language` VALUES ('ne', 'Nepali');
INSERT INTO `obj_language` VALUES ('new', 'Newari');
INSERT INTO `obj_language` VALUES ('ng', 'Ndonga');
INSERT INTO `obj_language` VALUES ('nia', 'Nias');
INSERT INTO `obj_language` VALUES ('niu', 'Niuean');
INSERT INTO `obj_language` VALUES ('njo', 'Ao Naga');
INSERT INTO `obj_language` VALUES ('nl', 'Dutch');
INSERT INTO `obj_language` VALUES ('nl_BE', 'Flemish');
INSERT INTO `obj_language` VALUES ('nmg', 'Kwasio');
INSERT INTO `obj_language` VALUES ('nn', 'Norwegian Nynorsk');
INSERT INTO `obj_language` VALUES ('nnh', 'Ngiemboon');
INSERT INTO `obj_language` VALUES ('no', 'Norwegian');
INSERT INTO `obj_language` VALUES ('nog', 'Nogai');
INSERT INTO `obj_language` VALUES ('non', 'Old Norse');
INSERT INTO `obj_language` VALUES ('nov', 'Novial');
INSERT INTO `obj_language` VALUES ('nqo', 'N’Ko');
INSERT INTO `obj_language` VALUES ('nr', 'South Ndebele');
INSERT INTO `obj_language` VALUES ('nso', 'Northern Sotho');
INSERT INTO `obj_language` VALUES ('nus', 'Nuer');
INSERT INTO `obj_language` VALUES ('nv', 'Navajo');
INSERT INTO `obj_language` VALUES ('nwc', 'Classical Newari');
INSERT INTO `obj_language` VALUES ('ny', 'Nyanja');
INSERT INTO `obj_language` VALUES ('nym', 'Nyamwezi');
INSERT INTO `obj_language` VALUES ('nyn', 'Nyankole');
INSERT INTO `obj_language` VALUES ('nyo', 'Nyoro');
INSERT INTO `obj_language` VALUES ('nzi', 'Nzima');
INSERT INTO `obj_language` VALUES ('oc', 'Occitan');
INSERT INTO `obj_language` VALUES ('oj', 'Ojibwa');
INSERT INTO `obj_language` VALUES ('om', 'Oromo');
INSERT INTO `obj_language` VALUES ('or', 'Odia');
INSERT INTO `obj_language` VALUES ('os', 'Ossetic');
INSERT INTO `obj_language` VALUES ('osa', 'Osage');
INSERT INTO `obj_language` VALUES ('ota', 'Ottoman Turkish');
INSERT INTO `obj_language` VALUES ('pa', 'Punjabi');
INSERT INTO `obj_language` VALUES ('pag', 'Pangasinan');
INSERT INTO `obj_language` VALUES ('pal', 'Pahlavi');
INSERT INTO `obj_language` VALUES ('pam', 'Pampanga');
INSERT INTO `obj_language` VALUES ('pap', 'Papiamento');
INSERT INTO `obj_language` VALUES ('pau', 'Palauan');
INSERT INTO `obj_language` VALUES ('pcd', 'Picard');
INSERT INTO `obj_language` VALUES ('pcm', 'Nigerian Pidgin');
INSERT INTO `obj_language` VALUES ('pdc', 'Pennsylvania German');
INSERT INTO `obj_language` VALUES ('pdt', 'Plautdietsch');
INSERT INTO `obj_language` VALUES ('peo', 'Old Persian');
INSERT INTO `obj_language` VALUES ('pfl', 'Palatine German');
INSERT INTO `obj_language` VALUES ('phn', 'Phoenician');
INSERT INTO `obj_language` VALUES ('pi', 'Pali');
INSERT INTO `obj_language` VALUES ('pl', 'Polish');
INSERT INTO `obj_language` VALUES ('pms', 'Piedmontese');
INSERT INTO `obj_language` VALUES ('pnt', 'Pontic');
INSERT INTO `obj_language` VALUES ('pon', 'Pohnpeian');
INSERT INTO `obj_language` VALUES ('prg', 'Prussian');
INSERT INTO `obj_language` VALUES ('pro', 'Old Provençal');
INSERT INTO `obj_language` VALUES ('ps', 'Pashto');
INSERT INTO `obj_language` VALUES ('pt', 'Portuguese');
INSERT INTO `obj_language` VALUES ('pt_BR', 'Brazilian Portuguese');
INSERT INTO `obj_language` VALUES ('pt_PT', 'European Portuguese');
INSERT INTO `obj_language` VALUES ('qu', 'Quechua');
INSERT INTO `obj_language` VALUES ('quc', 'Kʼicheʼ');
INSERT INTO `obj_language` VALUES ('qug', 'Chimborazo Highland Quichua');
INSERT INTO `obj_language` VALUES ('raj', 'Rajasthani');
INSERT INTO `obj_language` VALUES ('rap', 'Rapanui');
INSERT INTO `obj_language` VALUES ('rar', 'Rarotongan');
INSERT INTO `obj_language` VALUES ('rgn', 'Romagnol');
INSERT INTO `obj_language` VALUES ('rif', 'Riffian');
INSERT INTO `obj_language` VALUES ('rm', 'Romansh');
INSERT INTO `obj_language` VALUES ('rn', 'Rundi');
INSERT INTO `obj_language` VALUES ('ro', 'Romanian');
INSERT INTO `obj_language` VALUES ('ro_MD', 'Moldavian');
INSERT INTO `obj_language` VALUES ('rof', 'Rombo');
INSERT INTO `obj_language` VALUES ('rom', 'Romany');
INSERT INTO `obj_language` VALUES ('root', 'Root');
INSERT INTO `obj_language` VALUES ('rtm', 'Rotuman');
INSERT INTO `obj_language` VALUES ('ru', 'Russian');
INSERT INTO `obj_language` VALUES ('rue', 'Rusyn');
INSERT INTO `obj_language` VALUES ('rug', 'Roviana');
INSERT INTO `obj_language` VALUES ('rup', 'Aromanian');
INSERT INTO `obj_language` VALUES ('rw', 'Kinyarwanda');
INSERT INTO `obj_language` VALUES ('rwk', 'Rwa');
INSERT INTO `obj_language` VALUES ('sa', 'Sanskrit');
INSERT INTO `obj_language` VALUES ('sad', 'Sandawe');
INSERT INTO `obj_language` VALUES ('sah', 'Sakha');
INSERT INTO `obj_language` VALUES ('sam', 'Samaritan Aramaic');
INSERT INTO `obj_language` VALUES ('saq', 'Samburu');
INSERT INTO `obj_language` VALUES ('sas', 'Sasak');
INSERT INTO `obj_language` VALUES ('sat', 'Santali');
INSERT INTO `obj_language` VALUES ('saz', 'Saurashtra');
INSERT INTO `obj_language` VALUES ('sba', 'Ngambay');
INSERT INTO `obj_language` VALUES ('sbp', 'Sangu');
INSERT INTO `obj_language` VALUES ('sc', 'Sardinian');
INSERT INTO `obj_language` VALUES ('scn', 'Sicilian');
INSERT INTO `obj_language` VALUES ('sco', 'Scots');
INSERT INTO `obj_language` VALUES ('sd', 'Sindhi');
INSERT INTO `obj_language` VALUES ('sdc', 'Sassarese Sardinian');
INSERT INTO `obj_language` VALUES ('sdh', 'Southern Kurdish');
INSERT INTO `obj_language` VALUES ('se', 'Northern Sami');
INSERT INTO `obj_language` VALUES ('see', 'Seneca');
INSERT INTO `obj_language` VALUES ('seh', 'Sena');
INSERT INTO `obj_language` VALUES ('sei', 'Seri');
INSERT INTO `obj_language` VALUES ('sel', 'Selkup');
INSERT INTO `obj_language` VALUES ('ses', 'Koyraboro Senni');
INSERT INTO `obj_language` VALUES ('sg', 'Sango');
INSERT INTO `obj_language` VALUES ('sga', 'Old Irish');
INSERT INTO `obj_language` VALUES ('sgs', 'Samogitian');
INSERT INTO `obj_language` VALUES ('sh', 'Serbo-Croatian');
INSERT INTO `obj_language` VALUES ('shi', 'Tachelhit');
INSERT INTO `obj_language` VALUES ('shn', 'Shan');
INSERT INTO `obj_language` VALUES ('shu', 'Chadian Arabic');
INSERT INTO `obj_language` VALUES ('si', 'Sinhala');
INSERT INTO `obj_language` VALUES ('sid', 'Sidamo');
INSERT INTO `obj_language` VALUES ('sk', 'Slovak');
INSERT INTO `obj_language` VALUES ('sl', 'Slovenian');
INSERT INTO `obj_language` VALUES ('sli', 'Lower Silesian');
INSERT INTO `obj_language` VALUES ('sly', 'Selayar');
INSERT INTO `obj_language` VALUES ('sm', 'Samoan');
INSERT INTO `obj_language` VALUES ('sma', 'Southern Sami');
INSERT INTO `obj_language` VALUES ('smj', 'Lule Sami');
INSERT INTO `obj_language` VALUES ('smn', 'Inari Sami');
INSERT INTO `obj_language` VALUES ('sms', 'Skolt Sami');
INSERT INTO `obj_language` VALUES ('sn', 'Shona');
INSERT INTO `obj_language` VALUES ('snk', 'Soninke');
INSERT INTO `obj_language` VALUES ('so', 'Somali');
INSERT INTO `obj_language` VALUES ('sog', 'Sogdien');
INSERT INTO `obj_language` VALUES ('sq', 'Albanian');
INSERT INTO `obj_language` VALUES ('sr', 'Serbian');
INSERT INTO `obj_language` VALUES ('srn', 'Sranan Tongo');
INSERT INTO `obj_language` VALUES ('srr', 'Serer');
INSERT INTO `obj_language` VALUES ('ss', 'Swati');
INSERT INTO `obj_language` VALUES ('ssy', 'Saho');
INSERT INTO `obj_language` VALUES ('st', 'Southern Sotho');
INSERT INTO `obj_language` VALUES ('stq', 'Saterland Frisian');
INSERT INTO `obj_language` VALUES ('su', 'Sundanese');
INSERT INTO `obj_language` VALUES ('suk', 'Sukuma');
INSERT INTO `obj_language` VALUES ('sus', 'Susu');
INSERT INTO `obj_language` VALUES ('sux', 'Sumerian');
INSERT INTO `obj_language` VALUES ('sv', 'Swedish');
INSERT INTO `obj_language` VALUES ('sw', 'Swahili');
INSERT INTO `obj_language` VALUES ('sw_CD', 'Congo Swahili');
INSERT INTO `obj_language` VALUES ('swb', 'Comorian');
INSERT INTO `obj_language` VALUES ('syc', 'Classical Syriac');
INSERT INTO `obj_language` VALUES ('syr', 'Syriac');
INSERT INTO `obj_language` VALUES ('szl', 'Silesian');
INSERT INTO `obj_language` VALUES ('ta', 'Tamil');
INSERT INTO `obj_language` VALUES ('te', 'Telugu');
INSERT INTO `obj_language` VALUES ('tem', 'Timne');
INSERT INTO `obj_language` VALUES ('teo', 'Teso');
INSERT INTO `obj_language` VALUES ('ter', 'Tereno');
INSERT INTO `obj_language` VALUES ('tet', 'Tetum');
INSERT INTO `obj_language` VALUES ('tg', 'Tajik');
INSERT INTO `obj_language` VALUES ('th', 'Thai');
INSERT INTO `obj_language` VALUES ('ti', 'Tigrinya');
INSERT INTO `obj_language` VALUES ('tig', 'Tigre');
INSERT INTO `obj_language` VALUES ('tiv', 'Tiv');
INSERT INTO `obj_language` VALUES ('tkl', 'Tokelau');
INSERT INTO `obj_language` VALUES ('tl', 'Tagalog');
INSERT INTO `obj_language` VALUES ('tlh', 'Klingon');
INSERT INTO `obj_language` VALUES ('tli', 'Tlingit');
INSERT INTO `obj_language` VALUES ('tly', 'Talysh');
INSERT INTO `obj_language` VALUES ('tmh', 'Tamashek');
INSERT INTO `obj_language` VALUES ('to', 'Tongan');
INSERT INTO `obj_language` VALUES ('tog', 'Nyasa Tonga');
INSERT INTO `obj_language` VALUES ('tpi', 'Tok Pisin');
INSERT INTO `obj_language` VALUES ('trv', 'Taroko');
INSERT INTO `obj_language` VALUES ('tt', 'Tatar');
INSERT INTO `obj_language` VALUES ('ttt', 'Muslim Tat');
INSERT INTO `obj_language` VALUES ('twq', 'Tasawaq');
INSERT INTO `obj_language` VALUES ('ty', 'Tahitian');
INSERT INTO `obj_language` VALUES ('tzm', 'Central Atlas Tamazight');
INSERT INTO `obj_language` VALUES ('vmf', 'Main-Franconian');
INSERT INTO `obj_language` VALUES ('xal', 'Kalmyk');
INSERT INTO `obj_language` VALUES ('xmf', 'Mingrelian');
INSERT INTO `obj_language` VALUES ('xog', 'Soga');
INSERT INTO `obj_language` VALUES ('yrl', 'Nheengatu');
INSERT INTO `obj_language` VALUES ('yue', 'Cantonese');
INSERT INTO `obj_language` VALUES ('zbl', 'Blissymbols');
INSERT INTO `obj_language` VALUES ('zgh', 'Standard Moroccan Tamazight');
INSERT INTO `obj_language` VALUES ('zh', 'Chinese');
INSERT INTO `obj_language` VALUES ('zh_Ha', 'Simplified Chinese');
INSERT INTO `obj_language` VALUES ('zxx', 'No linguistic content');
COMMIT;

-- ----------------------------
-- Table structure for obj_object
-- ----------------------------
DROP TABLE IF EXISTS `obj_object`;
CREATE TABLE `obj_object` (
  `guid` char(36) COLLATE utf8_unicode_ci NOT NULL COMMENT '(DC2Type:uuid)',
  `parent_guid` char(36) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '(DC2Type:uuid)',
  `type_id` char(36) COLLATE utf8_unicode_ci NOT NULL COMMENT '(DC2Type:uuid)',
  `reference_id` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  `name` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  `lower_name` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  `created` datetime NOT NULL,
  `updated` datetime NOT NULL,
  `active` tinyint(1) NOT NULL DEFAULT '0',
  `tree_id` varchar(64) COLLATE utf8_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`guid`),
  UNIQUE KEY `UNIQ_3C2AB1CB1645DEA9` (`reference_id`),
  KEY `IDX_3C2AB1CB168CF906` (`parent_guid`),
  KEY `IDX_3C2AB1CBC54C8C93` (`type_id`),
  KEY `reference_idx` (`reference_id`),
  KEY `name_idx` (`lower_name`),
  KEY `tree_idx` (`tree_id`),
  CONSTRAINT `FK_3C2AB1CB168CF906` FOREIGN KEY (`parent_guid`) REFERENCES `obj_object` (`guid`) ON DELETE CASCADE,
  CONSTRAINT `FK_3C2AB1CBC54C8C93` FOREIGN KEY (`type_id`) REFERENCES `obj_type` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

-- ----------------------------
-- Records of obj_object
-- ----------------------------
BEGIN;
INSERT INTO `obj_object` VALUES ('072626fc-cd53-4d1a-afee-f6edd78b23e6', '7374db5a-1322-4500-83e3-cb2258ae4f4f', '200c15bf-6751-4b6b-81cd-8c1f66e51990', 'starShips', 'Star Ships', 'star ships', '2018-01-15 08:31:41', '2018-01-15 08:31:41', 1, '1.01');
INSERT INTO `obj_object` VALUES ('08ab2d0c-d5fb-40a8-b367-154d24ffe2d0', '952cd981-c262-498e-b353-5274c97361ca', '200c15bf-6751-4b6b-81cd-8c1f66e51990', 'hc2', 'Pax Magellanic', 'pax magellanic', '2018-01-15 08:22:16', '2018-01-15 08:22:16', 1, '1.01.01.01.01');
INSERT INTO `obj_object` VALUES ('0e7e9343-2a0c-4d1f-b827-7b40e029ebe2', '95800d1a-5eb7-41cb-95ad-eb928501312b', '200c15bf-6751-4b6b-81cd-8c1f66e51990', 'constitutionClass', 'Constitution Class', 'constitution class', '2018-01-15 08:09:13', '2018-01-15 08:09:13', 1, '1.01.01.02');
INSERT INTO `obj_object` VALUES ('201fa2fc-7cf2-4db6-bf50-921c235f6b00', '0e7e9343-2a0c-4d1f-b827-7b40e029ebe2', '200c15bf-6751-4b6b-81cd-8c1f66e51990', 'cc4', 'USS Defiant', 'uss defiant', '2018-01-15 08:13:58', '2018-01-15 08:13:58', 1, '1.01.01.02.01');
INSERT INTO `obj_object` VALUES ('388a8166-865b-43e1-8750-0ace7393fba3', 'a2854f06-9919-4509-9a70-4a202eaa1161', '4164db21-e83d-4fc3-b9b3-b3133d8eb071', 'sp3', 'Empok Nor', 'empok nor', '2018-01-15 08:37:26', '2018-01-15 08:37:26', 1, '1.02.01');
INSERT INTO `obj_object` VALUES ('3dfbe5b5-047b-4ed9-9334-a18b6f5b48da', 'a2854f06-9919-4509-9a70-4a202eaa1161', '4164db21-e83d-4fc3-b9b3-b3133d8eb071', 'sp1', 'Babylon 5', 'babylon 5', '2018-01-15 08:36:38', '2018-01-15 08:36:38', 1, '1.02.02');
INSERT INTO `obj_object` VALUES ('4ff8961e-3274-4c06-a72e-3e6b79f23ac4', 'bfad1be1-6721-4f31-b81c-05e5bb23eeec', '200c15bf-6751-4b6b-81cd-8c1f66e51990', 'f5', 'F302', 'f302', '2018-01-15 08:26:45', '2018-01-15 08:26:45', 1, '1.01.02.01');
INSERT INTO `obj_object` VALUES ('57ee3a7c-5e8d-4026-913b-9ea0bb5fa2fd', 'a2854f06-9919-4509-9a70-4a202eaa1161', '4164db21-e83d-4fc3-b9b3-b3133d8eb071', 'sp5', 'ISS', 'iss', '2018-01-15 08:39:56', '2018-01-15 08:39:56', 1, '1.02.03');
INSERT INTO `obj_object` VALUES ('5c2c203b-c469-4e96-90ab-f0aaf5c412ed', 'bfad1be1-6721-4f31-b81c-05e5bb23eeec', '200c15bf-6751-4b6b-81cd-8c1f66e51990', 'f3', 'X-Wing', 'x-wing', '2018-01-15 08:25:50', '2018-01-15 08:25:50', 1, '1.01.02.02');
INSERT INTO `obj_object` VALUES ('70440f24-509e-4932-aeff-4077ad8b2d3f', 'bfad1be1-6721-4f31-b81c-05e5bb23eeec', '200c15bf-6751-4b6b-81cd-8c1f66e51990', 'f4', 'Y-Wing', 'y-wing', '2018-01-15 08:26:11', '2018-01-15 08:26:11', 1, '1.01.02.03');
INSERT INTO `obj_object` VALUES ('7374db5a-1322-4500-83e3-cb2258ae4f4f', NULL, '689c204d-776f-4ce6-a250-91ac87e1b7ee', 'fcroot', 'FutureCollection', 'futurecollection', '2018-01-15 08:11:04', '2018-01-15 08:11:04', 1, '1');
INSERT INTO `obj_object` VALUES ('7e196a2d-a986-4b91-b1d0-ef6ccf4d26a6', 'a2854f06-9919-4509-9a70-4a202eaa1161', '4164db21-e83d-4fc3-b9b3-b3133d8eb071', 'sp7', 'Midway Station', 'midway station', '2018-01-15 08:41:07', '2018-01-15 08:41:07', 1, '1.02.04');
INSERT INTO `obj_object` VALUES ('82864a4b-e3bb-4c50-9533-cf2a31252413', 'c89225be-493a-4cc5-8379-ecda8dafd035', '200c15bf-6751-4b6b-81cd-8c1f66e51990', 'gc2', 'USS Yamato', 'uss yamato', '2018-01-15 08:18:08', '2018-01-15 08:18:08', 1, '1.01.01.03.01');
INSERT INTO `obj_object` VALUES ('905882ad-fdce-43da-95c3-3d372c1b63cf', 'a2854f06-9919-4509-9a70-4a202eaa1161', '4164db21-e83d-4fc3-b9b3-b3133d8eb071', 'sp4', 'Hutton Orbital', 'hutton orbital', '2018-01-15 08:38:06', '2018-01-15 08:39:00', 1, '1.02.05');
INSERT INTO `obj_object` VALUES ('952cd981-c262-498e-b353-5274c97361ca', '95800d1a-5eb7-41cb-95ad-eb928501312b', '200c15bf-6751-4b6b-81cd-8c1f66e51990', 'heritageClass', 'Heritage Class', 'heritage class', '2018-01-15 08:20:38', '2018-01-15 08:20:38', 1, '1.01.01.01');
INSERT INTO `obj_object` VALUES ('95800d1a-5eb7-41cb-95ad-eb928501312b', '072626fc-cd53-4d1a-afee-f6edd78b23e6', '200c15bf-6751-4b6b-81cd-8c1f66e51990', 'cruiser', 'Cruiser', 'cruiser', '2018-01-15 08:08:07', '2018-01-15 08:32:23', 1, '1.01.01');
INSERT INTO `obj_object` VALUES ('a2854f06-9919-4509-9a70-4a202eaa1161', '7374db5a-1322-4500-83e3-cb2258ae4f4f', '4164db21-e83d-4fc3-b9b3-b3133d8eb071', 'spaceStations', 'Space Stations', 'space stations', '2018-01-15 08:28:56', '2018-01-15 08:28:56', 1, '1.02');
INSERT INTO `obj_object` VALUES ('b3165ee0-ecd6-4d4c-aea0-69a28a296eaa', '0e7e9343-2a0c-4d1f-b827-7b40e029ebe2', '200c15bf-6751-4b6b-81cd-8c1f66e51990', 'cc1', 'USS Farragut', 'uss farragut', '2018-01-15 08:10:13', '2018-01-15 08:10:13', 1, '1.01.01.02.02');
INSERT INTO `obj_object` VALUES ('b3d0429a-39c4-460e-98bb-2337cb714ea2', 'a2854f06-9919-4509-9a70-4a202eaa1161', '4164db21-e83d-4fc3-b9b3-b3133d8eb071', 'sp6', '„Not a Moon“ a.k.a. „Death Star”', '„not a moon“ a.k.a. „death star”', '2018-01-15 08:40:25', '2018-01-15 08:40:25', 1, '1.02.06');
INSERT INTO `obj_object` VALUES ('b71db8ac-15d1-49c4-bb08-9b87ff423561', 'bfad1be1-6721-4f31-b81c-05e5bb23eeec', '200c15bf-6751-4b6b-81cd-8c1f66e51990', 'f1', 'Colonial Viper MK2', 'colonial viper mk2', '2018-01-15 08:25:04', '2018-01-15 08:25:04', 1, '1.01.02.04');
INSERT INTO `obj_object` VALUES ('b97d38d7-2d9f-4c3d-8c3e-2d6b8b8f6bde', 'c89225be-493a-4cc5-8379-ecda8dafd035', '200c15bf-6751-4b6b-81cd-8c1f66e51990', 'gc1', 'USS Galaxy', 'uss galaxy', '2018-01-15 08:17:13', '2018-01-15 08:19:00', 1, '1.01.01.03.02');
INSERT INTO `obj_object` VALUES ('bbdb6b2c-ccf2-4f1e-92ce-431b8cbb20a3', '0e7e9343-2a0c-4d1f-b827-7b40e029ebe2', '200c15bf-6751-4b6b-81cd-8c1f66e51990', 'cc3', 'USS Enterprise', 'uss enterprise', '2018-01-15 08:13:25', '2018-01-15 08:13:25', 1, '1.01.01.02.03');
INSERT INTO `obj_object` VALUES ('bfad1be1-6721-4f31-b81c-05e5bb23eeec', '072626fc-cd53-4d1a-afee-f6edd78b23e6', '200c15bf-6751-4b6b-81cd-8c1f66e51990', 'fighter', 'Fighter', 'fighter', '2018-01-15 08:24:03', '2018-01-15 08:35:07', 1, '1.01.02');
INSERT INTO `obj_object` VALUES ('c771862a-19fb-40c7-b590-aa756383b362', 'bfad1be1-6721-4f31-b81c-05e5bb23eeec', '200c15bf-6751-4b6b-81cd-8c1f66e51990', 'f2', 'Colonial Viper MK7', 'colonial viper mk7', '2018-01-15 08:25:31', '2018-01-15 08:25:31', 1, '1.01.02.05');
INSERT INTO `obj_object` VALUES ('c89225be-493a-4cc5-8379-ecda8dafd035', '95800d1a-5eb7-41cb-95ad-eb928501312b', '200c15bf-6751-4b6b-81cd-8c1f66e51990', 'galaxyClass', 'Galaxy Class', 'galaxy class', '2018-01-15 08:15:33', '2018-01-15 08:15:33', 1, '1.01.01.03');
INSERT INTO `obj_object` VALUES ('cb08789d-28e0-4dbe-992c-1a648cf74208', '0e7e9343-2a0c-4d1f-b827-7b40e029ebe2', '200c15bf-6751-4b6b-81cd-8c1f66e51990', 'cc2', 'USS Valiant', 'uss valiant', '2018-01-15 08:12:47', '2018-01-15 08:12:47', 1, '1.01.01.02.04');
INSERT INTO `obj_object` VALUES ('edd39d40-915c-4800-916c-d5676c905a2e', '952cd981-c262-498e-b353-5274c97361ca', '200c15bf-6751-4b6b-81cd-8c1f66e51990', 'hc1', 'Andromeda Ascendant', 'andromeda ascendant', '2018-01-15 08:21:35', '2018-01-15 08:21:35', 1, '1.01.01.01.02');
INSERT INTO `obj_object` VALUES ('f495fc4c-c74b-41d5-a7cf-a5e2c2021814', 'a2854f06-9919-4509-9a70-4a202eaa1161', '4164db21-e83d-4fc3-b9b3-b3133d8eb071', 'sp2', 'Deep Space 9', 'deep space 9', '2018-01-15 08:37:04', '2018-01-15 08:37:04', 1, '1.02.07');
COMMIT;

-- ----------------------------
-- Table structure for obj_object_attribute_value
-- ----------------------------
DROP TABLE IF EXISTS `obj_object_attribute_value`;
CREATE TABLE `obj_object_attribute_value` (
  `id` char(36) COLLATE utf8_unicode_ci NOT NULL COMMENT '(DC2Type:uuid)',
  `object_guid` char(36) COLLATE utf8_unicode_ci NOT NULL COMMENT '(DC2Type:uuid)',
  `attribute_id` char(36) COLLATE utf8_unicode_ci NOT NULL COMMENT '(DC2Type:uuid)',
  `language_id` varchar(5) COLLATE utf8_unicode_ci NOT NULL,
  `value` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  `created` datetime NOT NULL,
  `updated` datetime NOT NULL,
  PRIMARY KEY (`id`),
  KEY `IDX_128710C8B67AF3A1` (`object_guid`),
  KEY `IDX_128710C8B6E62EFA` (`attribute_id`),
  KEY `IDX_128710C882F1BAF4` (`language_id`),
  CONSTRAINT `FK_128710C882F1BAF4` FOREIGN KEY (`language_id`) REFERENCES `obj_language` (`id`),
  CONSTRAINT `FK_128710C8B67AF3A1` FOREIGN KEY (`object_guid`) REFERENCES `obj_object` (`guid`) ON DELETE CASCADE,
  CONSTRAINT `FK_128710C8B6E62EFA` FOREIGN KEY (`attribute_id`) REFERENCES `obj_attribute` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

-- ----------------------------
-- Records of obj_object_attribute_value
-- ----------------------------
BEGIN;
INSERT INTO `obj_object_attribute_value` VALUES ('3aade0b9-83d0-49c7-99c3-3e0468c39fef', '201fa2fc-7cf2-4db6-bf50-921c235f6b00', 'b1c16a8b-d5d7-4f4e-bd3d-4906aa9a4d6d', 'tlh', 'Star Trek', '2018-01-15 09:25:25', '2018-01-15 09:25:25');
INSERT INTO `obj_object_attribute_value` VALUES ('3f149126-9ea4-4810-9ff7-bda98fb67f86', '82864a4b-e3bb-4c50-9533-cf2a31252413', 'b1c16a8b-d5d7-4f4e-bd3d-4906aa9a4d6d', 'tlh', 'Star Trek', '2018-01-15 09:32:03', '2018-01-15 09:32:03');
INSERT INTO `obj_object_attribute_value` VALUES ('7195c25d-c161-4503-85ef-644bfc6b2ab2', '5c2c203b-c469-4e96-90ab-f0aaf5c412ed', '0c016c60-04ce-4a08-a128-e214e790cb1f', 'tlh', '2', '2018-01-15 09:22:34', '2018-01-15 09:22:34');
INSERT INTO `obj_object_attribute_value` VALUES ('73b7005e-38ae-4e11-9c65-52e0df8668e7', 'bbdb6b2c-ccf2-4f1e-92ce-431b8cbb20a3', 'b1c16a8b-d5d7-4f4e-bd3d-4906aa9a4d6d', 'tlh', 'Star Trek', '2018-01-15 09:31:05', '2018-01-15 09:31:05');
INSERT INTO `obj_object_attribute_value` VALUES ('9dc19deb-3d44-4ba2-b1f8-b6f464b402a3', 'b71db8ac-15d1-49c4-bb08-9b87ff423561', '0c016c60-04ce-4a08-a128-e214e790cb1f', 'tlh', '1', '2018-01-15 09:23:48', '2018-01-15 09:23:48');
INSERT INTO `obj_object_attribute_value` VALUES ('ad64aced-5179-40bd-8bf6-fd4b2a1a2ed7', 'bbdb6b2c-ccf2-4f1e-92ce-431b8cbb20a3', '0c016c60-04ce-4a08-a128-e214e790cb1f', 'tlh', '346', '2018-01-15 09:24:40', '2018-01-15 09:24:40');
INSERT INTO `obj_object_attribute_value` VALUES ('ebaf30c6-6ca4-4412-a4d7-1ae17e4bed96', 'cb08789d-28e0-4dbe-992c-1a648cf74208', '0c016c60-04ce-4a08-a128-e214e790cb1f', 'tlh', '234', '2018-01-15 09:19:51', '2018-01-15 09:22:52');
INSERT INTO `obj_object_attribute_value` VALUES ('f5c583df-7fef-4648-a3c6-bb5042dda80d', 'f495fc4c-c74b-41d5-a7cf-a5e2c2021814', '0c016c60-04ce-4a08-a128-e214e790cb1f', 'tlh', '194', '2018-01-15 09:21:18', '2018-01-15 09:23:11');
COMMIT;

-- ----------------------------
-- Table structure for obj_type
-- ----------------------------
DROP TABLE IF EXISTS `obj_type`;
CREATE TABLE `obj_type` (
  `id` char(36) COLLATE utf8_unicode_ci NOT NULL COMMENT '(DC2Type:uuid)',
  `name` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  `lower_name` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  `type_order` int(10) unsigned DEFAULT NULL,
  `created` datetime NOT NULL,
  `updated` datetime NOT NULL,
  PRIMARY KEY (`id`),
  KEY `name_idx` (`name`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

-- ----------------------------
-- Records of obj_type
-- ----------------------------
BEGIN;
INSERT INTO `obj_type` VALUES ('200c15bf-6751-4b6b-81cd-8c1f66e51990', 'StarShips', 'starships', 1, '2018-01-15 08:06:27', '2018-01-15 08:06:27');
INSERT INTO `obj_type` VALUES ('4164db21-e83d-4fc3-b9b3-b3133d8eb071', 'SpaceStations', 'spacestations', 2, '2018-01-15 08:06:47', '2018-01-15 08:06:47');
INSERT INTO `obj_type` VALUES ('689c204d-776f-4ce6-a250-91ac87e1b7ee', 'FutureCollection', 'futurecollection', 0, '2018-01-15 08:05:53', '2018-01-15 08:05:53');
COMMIT;

-- ----------------------------
-- Table structure for obj_type_has_attribute_group
-- ----------------------------
DROP TABLE IF EXISTS `obj_type_has_attribute_group`;
CREATE TABLE `obj_type_has_attribute_group` (
  `attribute_group_id` char(36) COLLATE utf8_unicode_ci NOT NULL COMMENT '(DC2Type:uuid)',
  `type_id` char(36) COLLATE utf8_unicode_ci NOT NULL COMMENT '(DC2Type:uuid)',
  PRIMARY KEY (`attribute_group_id`,`type_id`),
  KEY `IDX_A636F69362D643B7` (`attribute_group_id`),
  KEY `IDX_A636F693C54C8C93` (`type_id`),
  CONSTRAINT `FK_A636F69362D643B7` FOREIGN KEY (`attribute_group_id`) REFERENCES `obj_attribute_group` (`id`),
  CONSTRAINT `FK_A636F693C54C8C93` FOREIGN KEY (`type_id`) REFERENCES `obj_type` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

-- ----------------------------
-- Records of obj_type_has_attribute_group
-- ----------------------------
BEGIN;
INSERT INTO `obj_type_has_attribute_group` VALUES ('18c2ed9b-51e5-4590-b5d5-23c75375ed1a', '4164db21-e83d-4fc3-b9b3-b3133d8eb071');
INSERT INTO `obj_type_has_attribute_group` VALUES ('2fa9c7cf-4d52-4139-a3a9-713b6d5e7037', '200c15bf-6751-4b6b-81cd-8c1f66e51990');
INSERT INTO `obj_type_has_attribute_group` VALUES ('e519d7b1-9177-48d6-a0b5-f4a1901a8519', '200c15bf-6751-4b6b-81cd-8c1f66e51990');
INSERT INTO `obj_type_has_attribute_group` VALUES ('e519d7b1-9177-48d6-a0b5-f4a1901a8519', '4164db21-e83d-4fc3-b9b3-b3133d8eb071');
INSERT INTO `obj_type_has_attribute_group` VALUES ('e519d7b1-9177-48d6-a0b5-f4a1901a8519', '689c204d-776f-4ce6-a250-91ac87e1b7ee');
COMMIT;

-- ----------------------------
-- Table structure for obj_type_mapping
-- ----------------------------
DROP TABLE IF EXISTS `obj_type_mapping`;
CREATE TABLE `obj_type_mapping` (
  `identifier` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  `type_id` char(36) COLLATE utf8_unicode_ci NOT NULL COMMENT '(DC2Type:uuid)',
  `created` datetime NOT NULL,
  `updated` datetime NOT NULL,
  PRIMARY KEY (`identifier`),
  UNIQUE KEY `UNIQ_DBAA677CC54C8C93` (`type_id`),
  CONSTRAINT `FK_DBAA677CC54C8C93` FOREIGN KEY (`type_id`) REFERENCES `obj_type` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

-- ----------------------------
-- Table structure for objects_import_config
-- ----------------------------
DROP TABLE IF EXISTS `objects_import_config`;
CREATE TABLE `objects_import_config` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `column_name` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  `object_value_id` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

-- ----------------------------
-- Records of objects_import_config
-- ----------------------------
BEGIN;
INSERT INTO `objects_import_config` VALUES (1, 'test', '42b0909e-ccc9-49d7-8b19-7d9223ba5675');
COMMIT;

-- ----------------------------
-- Table structure for system_log
-- ----------------------------
DROP TABLE IF EXISTS `system_log`;
CREATE TABLE `system_log` (
  `id` varchar(64) COLLATE utf8_unicode_ci NOT NULL,
  `level` int(11) DEFAULT NULL,
  `channel` varchar(32) COLLATE utf8_unicode_ci DEFAULT NULL,
  `extras` varchar(32) COLLATE utf8_unicode_ci DEFAULT NULL,
  `modified` datetime NOT NULL,
  `created` datetime NOT NULL,
  `createdTime` bigint(20) unsigned NOT NULL,
  PRIMARY KEY (`id`),
  KEY `idx_level` (`level`,`createdTime`,`created`,`modified`,`extras`,`channel`),
  KEY `idx_channel` (`channel`,`createdTime`,`created`,`modified`,`extras`,`level`),
  KEY `idx_extras` (`extras`,`createdTime`,`created`,`modified`,`channel`,`level`),
  KEY `idx_createdTime` (`createdTime`,`created`,`modified`,`extras`,`channel`,`level`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

-- ----------------------------
-- Table structure for system_log_data
-- ----------------------------
DROP TABLE IF EXISTS `system_log_data`;
CREATE TABLE `system_log_data` (
  `id` varchar(64) COLLATE utf8_unicode_ci NOT NULL,
  `log` longtext COLLATE utf8_unicode_ci,
  `serverData` longtext COLLATE utf8_unicode_ci,
  PRIMARY KEY (`id`),
  CONSTRAINT `FK_D577AC94BF396750` FOREIGN KEY (`id`) REFERENCES `system_log` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

-- ----------------------------
-- Table structure for webservice_access_log
-- ----------------------------
DROP TABLE IF EXISTS `webservice_access_log`;
CREATE TABLE `webservice_access_log` (
  `id` char(36) COLLATE utf8_unicode_ci NOT NULL COMMENT '(DC2Type:guid)',
  `username` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  `token` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `services` longtext COLLATE utf8_unicode_ci NOT NULL COMMENT '(DC2Type:array)',
  `created_at` datetime NOT NULL,
  `updated_at` datetime NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

-- ----------------------------
-- Records of webservice_access_log
-- ----------------------------
BEGIN;
INSERT INTO `webservice_access_log` VALUES ('7183f220-f528-11e7-8df6-3ef71eb11d7c', 'webSp-testenv', 'V2030cOhc6Vttcxs6r6bmtdlc8Z1ryTN1TQ16pjivEcprZhye9e17ba7508a4358f99c8ba52ded0f70RnZDhDyKMXLEWobXI2ZOrJ7mXjcPJJNk7wxoAw8WUTk0IMYa', 'a:5:{s:12:\"LanguageShow\";s:12:\"LanguageShow\";s:7:\"TypeAdd\";s:7:\"TypeAdd\";s:8:\"TypeShow\";s:8:\"TypeShow\";s:14:\"ObjectTreeView\";s:14:\"ObjectTreeView\";s:15:\"ObjectShowMulti\";s:15:\"ObjectShowMulti\";}', '2018-01-09 11:32:51', '2018-01-15 11:26:22');
INSERT INTO `webservice_access_log` VALUES ('fc8ff776-f9e0-11e7-9701-2f0796db8919', 'webSp-testenv', 'X2222cOhc6Vttcxs6r6bmtdlc8Z1ryTN1TQ16pjivEcprZhye9e17ba7508a4358f99c8ba52ded0f70RnZDhDyKMXLEWobXI2ZOrJ7mXjcPJJNk7wxoAw8WUTk0IMYacOhc6Vttcxs6r6bmtdlc8Z1ryTN1TQ16pjivEcprZhye9e17ba7508a4358f99c8ba52ded0f70RnZDhDyKMXLEWobXI2ZOrJ7mXjcPJJNk7wxoAw8WUTk0IMYa', 'a:2:{s:14:\"ObjectTreeView\";s:14:\"ObjectTreeView\";s:12:\"LanguageShow\";s:12:\"LanguageShow\";}', '2018-01-15 11:43:56', '2018-01-15 12:11:52');
COMMIT;

-- ----------------------------
-- Table structure for wssp_servicename2services
-- ----------------------------
DROP TABLE IF EXISTS `wssp_servicename2services`;
CREATE TABLE `wssp_servicename2services` (
  `ServiceNameId` int(11) NOT NULL,
  `ServiceId` int(11) NOT NULL,
  PRIMARY KEY (`ServiceNameId`,`ServiceId`),
  KEY `IDX_9B97AD8C5CC2A9D4` (`ServiceNameId`),
  KEY `IDX_9B97AD8CB98FD0B` (`ServiceId`),
  CONSTRAINT `FK_9B97AD8C5CC2A9D4` FOREIGN KEY (`ServiceNameId`) REFERENCES `wssp_servicenames` (`ServiceNameId`),
  CONSTRAINT `FK_9B97AD8CB98FD0B` FOREIGN KEY (`ServiceId`) REFERENCES `wssp_services` (`ServiceId`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

-- ----------------------------
-- Records of wssp_servicename2services
-- ----------------------------
BEGIN;
INSERT INTO `wssp_servicename2services` VALUES (1, 1);
INSERT INTO `wssp_servicename2services` VALUES (1, 2);
INSERT INTO `wssp_servicename2services` VALUES (1, 3);
INSERT INTO `wssp_servicename2services` VALUES (1, 4);
INSERT INTO `wssp_servicename2services` VALUES (1, 5);
INSERT INTO `wssp_servicename2services` VALUES (1, 6);
INSERT INTO `wssp_servicename2services` VALUES (1, 7);
INSERT INTO `wssp_servicename2services` VALUES (1, 8);
INSERT INTO `wssp_servicename2services` VALUES (1, 9);
INSERT INTO `wssp_servicename2services` VALUES (1, 10);
INSERT INTO `wssp_servicename2services` VALUES (1, 11);
INSERT INTO `wssp_servicename2services` VALUES (1, 12);
INSERT INTO `wssp_servicename2services` VALUES (1, 13);
INSERT INTO `wssp_servicename2services` VALUES (1, 14);
INSERT INTO `wssp_servicename2services` VALUES (1, 15);
INSERT INTO `wssp_servicename2services` VALUES (1, 16);
INSERT INTO `wssp_servicename2services` VALUES (1, 17);
INSERT INTO `wssp_servicename2services` VALUES (1, 18);
INSERT INTO `wssp_servicename2services` VALUES (1, 19);
INSERT INTO `wssp_servicename2services` VALUES (1, 20);
INSERT INTO `wssp_servicename2services` VALUES (1, 21);
INSERT INTO `wssp_servicename2services` VALUES (1, 22);
INSERT INTO `wssp_servicename2services` VALUES (1, 23);
INSERT INTO `wssp_servicename2services` VALUES (1, 24);
INSERT INTO `wssp_servicename2services` VALUES (1, 25);
INSERT INTO `wssp_servicename2services` VALUES (1, 26);
INSERT INTO `wssp_servicename2services` VALUES (1, 27);
INSERT INTO `wssp_servicename2services` VALUES (1, 28);
COMMIT;

-- ----------------------------
-- Table structure for wssp_servicenames
-- ----------------------------
DROP TABLE IF EXISTS `wssp_servicenames`;
CREATE TABLE `wssp_servicenames` (
  `ServiceNameId` int(11) NOT NULL AUTO_INCREMENT,
  `ServiceName` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  `ServiceActive` smallint(6) NOT NULL,
  PRIMARY KEY (`ServiceNameId`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

-- ----------------------------
-- Records of wssp_servicenames
-- ----------------------------
BEGIN;
INSERT INTO `wssp_servicenames` VALUES (1, 'MyService', 1);
COMMIT;

-- ----------------------------
-- Table structure for wssp_services
-- ----------------------------
DROP TABLE IF EXISTS `wssp_services`;
CREATE TABLE `wssp_services` (
  `ServiceId` int(11) NOT NULL AUTO_INCREMENT,
  `ServiceType` varchar(100) COLLATE utf8_unicode_ci NOT NULL,
  `ServiceController` varchar(100) COLLATE utf8_unicode_ci NOT NULL,
  `ServiceAction` varchar(100) COLLATE utf8_unicode_ci NOT NULL,
  `ServiceMapped2Group` varchar(100) COLLATE utf8_unicode_ci NOT NULL,
  PRIMARY KEY (`ServiceId`)
) ENGINE=InnoDB AUTO_INCREMENT=29 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

-- ----------------------------
-- Records of wssp_services
-- ----------------------------
BEGIN;
INSERT INTO `wssp_services` VALUES (1, 'intern', 'Object', 'Show', 'no');
INSERT INTO `wssp_services` VALUES (2, 'intern', 'Object', 'Add', 'no');
INSERT INTO `wssp_services` VALUES (3, 'intern', 'Object', 'Update', 'no');
INSERT INTO `wssp_services` VALUES (4, 'intern', 'Object', 'Delete', 'no');
INSERT INTO `wssp_services` VALUES (5, 'intern', 'Object', 'ShowAll', 'no');
INSERT INTO `wssp_services` VALUES (6, 'intern', 'Object', 'ShowParent', 'no');
INSERT INTO `wssp_services` VALUES (7, 'intern', 'Object', 'ShowChild', 'no');
INSERT INTO `wssp_services` VALUES (8, 'intern', 'Type', 'Show', 'no');
INSERT INTO `wssp_services` VALUES (9, 'intern', 'Type', 'Add', 'no');
INSERT INTO `wssp_services` VALUES (10, 'intern', 'Type', 'Update', 'no');
INSERT INTO `wssp_services` VALUES (11, 'intern', 'Type', 'Delete', 'no');
INSERT INTO `wssp_services` VALUES (12, 'intern', 'Type', 'ShowObjects', 'no');
INSERT INTO `wssp_services` VALUES (13, 'intern', 'Type', 'ShowAll', 'no');
INSERT INTO `wssp_services` VALUES (14, 'intern', 'Language', 'ShowAll', 'no');
INSERT INTO `wssp_services` VALUES (15, 'intern', 'AttributeGroup', 'Show', 'no');
INSERT INTO `wssp_services` VALUES (16, 'intern', 'AttributeGroup', 'Add', 'no');
INSERT INTO `wssp_services` VALUES (17, 'intern', 'AttributeGroup', 'Update', 'no');
INSERT INTO `wssp_services` VALUES (18, 'intern', 'AttributeGroup', 'Delete', 'no');
INSERT INTO `wssp_services` VALUES (19, 'intern', 'AttributeGroup', 'ShowAll', 'no');
INSERT INTO `wssp_services` VALUES (20, 'intern', 'Language', 'Show', 'no');
INSERT INTO `wssp_services` VALUES (21, 'intern', 'Country', 'Show', 'no');
INSERT INTO `wssp_services` VALUES (22, 'intern', 'Attribute', 'Add', 'no');
INSERT INTO `wssp_services` VALUES (23, 'intern', 'Attribute', 'Show', 'no');
INSERT INTO `wssp_services` VALUES (24, 'intern', 'ObjectValue', 'Show', 'no');
INSERT INTO `wssp_services` VALUES (25, 'intern', 'ObjectValue', 'Add', 'no');
INSERT INTO `wssp_services` VALUES (26, 'intern', 'Object', 'TreeView', 'no');
INSERT INTO `wssp_services` VALUES (27, 'intern', 'Object', 'ShowSingle', 'no');
INSERT INTO `wssp_services` VALUES (28, 'intern', 'Object', 'ShowMulti', 'no');
COMMIT;

-- ----------------------------
-- Table structure for wssp_token2servicename
-- ----------------------------
DROP TABLE IF EXISTS `wssp_token2servicename`;
CREATE TABLE `wssp_token2servicename` (
  `ServiceToken` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  `ServiceNameId` int(11) NOT NULL,
  PRIMARY KEY (`ServiceToken`,`ServiceNameId`),
  KEY `IDX_6DCA695D15A19130` (`ServiceToken`),
  KEY `IDX_6DCA695D5CC2A9D4` (`ServiceNameId`),
  CONSTRAINT `FK_6DCA695D15A19130` FOREIGN KEY (`ServiceToken`) REFERENCES `wssp_tokens` (`ServiceToken`),
  CONSTRAINT `FK_6DCA695D5CC2A9D4` FOREIGN KEY (`ServiceNameId`) REFERENCES `wssp_servicenames` (`ServiceNameId`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

-- ----------------------------
-- Records of wssp_token2servicename
-- ----------------------------
BEGIN;
INSERT INTO `wssp_token2servicename` VALUES ('X2222cOhc6Vttcxs6r6bmtdlc8Z1ryTN1TQ16pjivEcprZhye9e17ba7508a4358f99c8ba52ded0f70RnZDhDyKMXLEWobXI2ZOrJ7mXjcPJJNk7wxoAw8WUTk0IMYacOhc6Vttcxs6r6bmtdlc8Z1ryTN1TQ16pjivEcprZhye9e17ba7508a4358f99c8ba52ded0f70RnZDhDyKMXLEWobXI2ZOrJ7mXjcPJJNk7wxoAw8WUTk0IMYa', 1);
COMMIT;

-- ----------------------------
-- Table structure for wssp_tokens
-- ----------------------------
DROP TABLE IF EXISTS `wssp_tokens`;
CREATE TABLE `wssp_tokens` (
  `ServiceToken` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  `ServiceToken2Ip` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  `AllowedCallsPerDay` int(11) NOT NULL,
  `ValidUntil` date NOT NULL,
  `Blocked` smallint(6) NOT NULL,
  `BlockedReason` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `Description` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  PRIMARY KEY (`ServiceToken`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

-- ----------------------------
-- Records of wssp_tokens
-- ----------------------------
BEGIN;
INSERT INTO `wssp_tokens` VALUES ('X2222cOhc6Vttcxs6r6bmtdlc8Z1ryTN1TQ16pjivEcprZhye9e17ba7508a4358f99c8ba52ded0f70RnZDhDyKMXLEWobXI2ZOrJ7mXjcPJJNk7wxoAw8WUTk0IMYacOhc6Vttcxs6r6bmtdlc8Z1ryTN1TQ16pjivEcprZhye9e17ba7508a4358f99c8ba52ded0f70RnZDhDyKMXLEWobXI2ZOrJ7mXjcPJJNk7wxoAw8WUTk0IMYa', '*', 10000, '2022-06-30', 0, NULL, 'Backend Test');
COMMIT;

-- ----------------------------
-- Table structure for wssp_tokenusage
-- ----------------------------
DROP TABLE IF EXISTS `wssp_tokenusage`;
CREATE TABLE `wssp_tokenusage` (
  `UsageId` varchar(64) COLLATE utf8_unicode_ci NOT NULL,
  `ServiceToken` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  `Date` datetime NOT NULL,
  `Ip` varchar(64) COLLATE utf8_unicode_ci DEFAULT NULL,
  `Controller` varchar(32) COLLATE utf8_unicode_ci DEFAULT NULL,
  `Action` varchar(32) COLLATE utf8_unicode_ci DEFAULT NULL,
  `TrackId` varchar(10) COLLATE utf8_unicode_ci DEFAULT NULL,
  `Status` varchar(10) COLLATE utf8_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`UsageId`),
  KEY `IDX_18F28BEC15A19130` (`ServiceToken`),
  KEY `idx_token` (`ServiceToken`,`Date`,`Controller`,`Action`),
  KEY `idx_date` (`Date`),
  CONSTRAINT `FK_18F28BEC15A19130` FOREIGN KEY (`ServiceToken`) REFERENCES `wssp_tokens` (`ServiceToken`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

-- ----------------------------
-- Records of wssp_tokenusage
-- ----------------------------
BEGIN;
INSERT INTO `wssp_tokenusage` VALUES ('2cbc7664a2c6b29b3f12ac66acd0df63dab9db89e752a09ccf1ab916b0985be0', 'X2222cOhc6Vttcxs6r6bmtdlc8Z1ryTN1TQ16pjivEcprZhye9e17ba7508a4358f99c8ba52ded0f70RnZDhDyKMXLEWobXI2ZOrJ7mXjcPJJNk7wxoAw8WUTk0IMYacOhc6Vttcxs6r6bmtdlc8Z1ryTN1TQ16pjivEcprZhye9e17ba7508a4358f99c8ba52ded0f70RnZDhDyKMXLEWobXI2ZOrJ7mXjcPJJNk7wxoAw8WUTk0IMYa', '2018-01-15 12:11:52', '127.0.0.1', 'Language', 'Show', '85ce0b5949', NULL);
INSERT INTO `wssp_tokenusage` VALUES ('8160a46947cf427914f5fc60f7223b426fe564f72c8356c305c51543eebbc660', 'X2222cOhc6Vttcxs6r6bmtdlc8Z1ryTN1TQ16pjivEcprZhye9e17ba7508a4358f99c8ba52ded0f70RnZDhDyKMXLEWobXI2ZOrJ7mXjcPJJNk7wxoAw8WUTk0IMYacOhc6Vttcxs6r6bmtdlc8Z1ryTN1TQ16pjivEcprZhye9e17ba7508a4358f99c8ba52ded0f70RnZDhDyKMXLEWobXI2ZOrJ7mXjcPJJNk7wxoAw8WUTk0IMYa', '2018-01-15 11:43:56', '127.0.0.1', 'Object', 'TreeView', '0a378cf134', NULL);
INSERT INTO `wssp_tokenusage` VALUES ('8f9e3fb42262bcf73967e51e08978917ab9f43f55cee8d7bd6f9d2ab2e3361d3', 'X2222cOhc6Vttcxs6r6bmtdlc8Z1ryTN1TQ16pjivEcprZhye9e17ba7508a4358f99c8ba52ded0f70RnZDhDyKMXLEWobXI2ZOrJ7mXjcPJJNk7wxoAw8WUTk0IMYacOhc6Vttcxs6r6bmtdlc8Z1ryTN1TQ16pjivEcprZhye9e17ba7508a4358f99c8ba52ded0f70RnZDhDyKMXLEWobXI2ZOrJ7mXjcPJJNk7wxoAw8WUTk0IMYa', '2018-01-15 12:10:22', '127.0.0.1', 'Language', 'Show', '39259c2e14', NULL);
INSERT INTO `wssp_tokenusage` VALUES ('c5beb49a90d3ed2eadcea383c28fce7e27dce86207e2238bde7a5bf87feb7ff1', 'X2222cOhc6Vttcxs6r6bmtdlc8Z1ryTN1TQ16pjivEcprZhye9e17ba7508a4358f99c8ba52ded0f70RnZDhDyKMXLEWobXI2ZOrJ7mXjcPJJNk7wxoAw8WUTk0IMYacOhc6Vttcxs6r6bmtdlc8Z1ryTN1TQ16pjivEcprZhye9e17ba7508a4358f99c8ba52ded0f70RnZDhDyKMXLEWobXI2ZOrJ7mXjcPJJNk7wxoAw8WUTk0IMYa', '2018-01-15 11:44:01', '127.0.0.1', 'Object', 'TreeView', 'a4dce8d397', NULL);
COMMIT;

SET FOREIGN_KEY_CHECKS = 1;
