<?php

/**
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is protected by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2018 Lifestyle Webconsulting GmbH
 * @version    $Id:$
 * @link       http://www.life-style.de
 */

namespace LifeStyle\Tools\CredentialsBundle\Api;

use LifeStyle\Tools\CredentialsBundle\Database\Manager as DatabaseManager;
use Symfony\Component\DependencyInjection\ContainerInterface as Container;

/**
 * Class Manager
 * @package LifeStyle\Tools\CredentialsBundle\Api
 */
class Manager
{
    /**
     * @var Container
     */
    private $container;

    /**
     * @var DatabaseManager
     */
    private $databaseManager;

    /**
     * Constructor
     * 
     * @param Container $container
     */
    public function __construct(Container $container)
    {
        $this->container = $container;
    }

    /**
     * @return \Symfony\Bridge\Monolog\Logger
     */
    public function logger()
    {
        return $this->container->get('logger');
    }

    /**
     * @return \Symfony\Component\Validator\Validator\ValidatorInterface
     */
    public function validator()
    {
        return $this->container->get('validator');
    }

    /**
     * @return \Symfony\Component\HttpKernel\Profiler\Profiler|null
     */
    public function profiler()
    {
        return $this->container->has('profiler') ? $this->container->get('profiler') : null;
    }

    /**
     * @return \LifeStyle\Tools\CredentialsBundle\Database\Manager
     */
    public function database()
    {
        $entityManagerName = $this->container->getParameter('lifestyle_credentials.database.entity_manager');
        return null !== $this->databaseManager ? $this->databaseManager : ($this->databaseManager = new DatabaseManager($this->container->get('doctrine')->getManager($entityManagerName)));
    }

    /**
     * @return \LifeStyle\Tools\WebserviceBundle\Error\Storage
     */
    public function errors()
    {
        return $this->container->get('lifestyle.webservice.error.storage');
    }

    /**
     * @return \JMS\Serializer\Serializer
     */
    public function serializer()
    {
        return $this->container->get('jms_serializer');
    }
}
