<?php

namespace LifeStyle\Tools\CredentialsBundle\DataFixtures\ORM;

use Doctrine\Common\DataFixtures\AbstractFixture;
use Doctrine\Common\DataFixtures\OrderedFixtureInterface;
use Doctrine\Common\Persistence\ObjectManager;
use LifeStyle\Tools\CredentialsBundle\Entity\ServiceName;

class LoadServiceNames extends AbstractFixture implements OrderedFixtureInterface
{

    /**
     * {@inheritDoc}
     */
    public function load(ObjectManager $manager)
    {
        $rows = array(
            array('MyService', 1)
        );
        foreach ($rows as $row) {
            $entity = new ServiceName();
            $entity->setServiceName($row[0])
                    ->setServiceActive($row[1]);
            $manager->persist($entity);
        }
        $manager->flush();
    }

    /**
     * {@inheritDoc}
     */
    public function getOrder()
    {
        return 1;
    }

}
