<?php

namespace LifeStyle\Tools\CredentialsBundle\DataFixtures\ORM;

use Doctrine\Common\DataFixtures\AbstractFixture;
use Doctrine\Common\DataFixtures\OrderedFixtureInterface;
use Doctrine\Common\Persistence\ObjectManager;

class LoadServiceNames2Services extends AbstractFixture implements OrderedFixtureInterface
{

    /**
     * {@inheritDoc}
     */
    public function load(ObjectManager $manager)
    {
        $services = $manager->getRepository('LifeStyle\Tools\CredentialsBundle\Entity\Service')->findAll();
        $serviceNames = $manager->getRepository('LifeStyle\Tools\CredentialsBundle\Entity\ServiceName')->findAll();
        foreach ($serviceNames as $serviceName) {
            foreach ($services as $service) {
                $service->addServiceName($serviceName);
                $manager->persist($service);
                $serviceName->addService($service);
                $manager->persist($serviceName);
            }
        }
        $manager->flush();
    }

    /**
     * {@inheritDoc}
     */
    public function getOrder()
    {
        return 4;
    }

}
