<?php

namespace LifeStyle\Tools\CredentialsBundle\DataFixtures\ORM;

use Doctrine\Common\DataFixtures\AbstractFixture;
use Doctrine\Common\DataFixtures\OrderedFixtureInterface;
use Doctrine\Common\Persistence\ObjectManager;

class LoadTokens2ServiceNames extends AbstractFixture implements OrderedFixtureInterface
{

    /**
     * {@inheritDoc}
     */
    public function load(ObjectManager $manager)
    {
        $serviceNames = $manager->getRepository('LifeStyle\Tools\CredentialsBundle\Entity\ServiceName')->findAll();
        $tokens = $manager->getRepository('LifeStyle\Tools\CredentialsBundle\Entity\Token')->findAll();
        foreach ($serviceNames as $serviceName) {
            foreach ($tokens as $token) {
                $token->addServiceName($serviceName);
                $manager->persist($token);
                $serviceName->addToken($token);
                $manager->persist($serviceName);
            }
        }
        $manager->flush();
    }

    /**
     * {@inheritDoc}
     */
    public function getOrder()
    {
        return 5;
    }

}
