<?php

/**
 * Webservice database handler
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is protected by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2015 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 */

namespace LifeStyle\Tools\CredentialsBundle\Database;

use Doctrine\ORM\EntityManager;

/**
 * Class Manager
 * @package LifeStyle\Tools\CredentialsBundle\Database
 */
class Manager
{
    /**
     * @var array
     */
    private $db = [];

    /**
     * @var EntityManager
     */
    private $entityManager;

    /**
     * @param \Doctrine\ORM\EntityManager $entityManager
     */
    public function __construct(EntityManager $entityManager)
    {
        $this->entityManager = $entityManager;
    }

    /**
     * @return \LifeStyle\Tools\CredentialsBundle\Database\Service
     */
    public function service()
    {
        return $this->getDatabase('Service');
    }

    /**
     * @return \LifeStyle\Tools\CredentialsBundle\Database\Token
     */
    public function token()
    {
        return $this->getDatabase('Token');
    }

    /**
     * @return \LifeStyle\Tools\CredentialsBundle\Database\TokenUsage
     */
    public function tokenUsage()
    {
        return $this->getDatabase('TokenUsage');
    }

    /**
     * @param string $class
     * @return Base Database
     */
    protected function getDatabase($class)
    {
        $class = __NAMESPACE__ . '\\' . $class;
        return isset($this->db[$class]) ? $this->db[$class] : ($this->db[$class] = new $class($this->entityManager));
    }
}
