<?php

namespace LifeStyle\Tools\CredentialsBundle\Entity;

use Doctrine\ORM\Mapping as ORM;

/**
 * Service
 */
class Service
{
    /**
     * @var integer
     */
    private $ServiceId;

    /**
     * @var string
     */
    private $ServiceType;

    /**
     * @var string
     */
    private $ServiceController;

    /**
     * @var string
     */
    private $ServiceAction;

    /**
     * @var string
     */
    private $ServiceMapped2Group;

    /**
     * @var \Doctrine\Common\Collections\Collection
     */
    private $ServiceNames;

    /**
     * Constructor
     */
    public function __construct()
    {
        $this->ServiceNames = new \Doctrine\Common\Collections\ArrayCollection();
    }

    /**
     * Get ServiceId
     *
     * @return integer 
     */
    public function getServiceId()
    {
        return $this->ServiceId;
    }

    /**
     * Set ServiceType
     *
     * @param string $serviceType
     * @return Service
     */
    public function setServiceType($serviceType)
    {
        $this->ServiceType = $serviceType;

        return $this;
    }

    /**
     * Get ServiceType
     *
     * @return string 
     */
    public function getServiceType()
    {
        return $this->ServiceType;
    }

    /**
     * Set ServiceController
     *
     * @param string $serviceController
     * @return Service
     */
    public function setServiceController($serviceController)
    {
        $this->ServiceController = $serviceController;

        return $this;
    }

    /**
     * Get ServiceController
     *
     * @return string 
     */
    public function getServiceController()
    {
        return $this->ServiceController;
    }

    /**
     * Set ServiceAction
     *
     * @param string $serviceAction
     * @return Service
     */
    public function setServiceAction($serviceAction)
    {
        $this->ServiceAction = $serviceAction;

        return $this;
    }

    /**
     * Get ServiceAction
     *
     * @return string 
     */
    public function getServiceAction()
    {
        return $this->ServiceAction;
    }

    /**
     * Set ServiceMapped2Group
     *
     * @param string $serviceMapped2Group
     * @return Service
     */
    public function setServiceMapped2Group($serviceMapped2Group)
    {
        $this->ServiceMapped2Group = $serviceMapped2Group;

        return $this;
    }

    /**
     * Get ServiceMapped2Group
     *
     * @return string 
     */
    public function getServiceMapped2Group()
    {
        return $this->ServiceMapped2Group;
    }

    /**
     * Add ServiceNames
     *
     * @param \LifeStyle\Tools\CredentialsBundle\Entity\ServiceName $serviceNames
     * @return Service
     */
    public function addServiceName(\LifeStyle\Tools\CredentialsBundle\Entity\ServiceName $serviceNames)
    {
        $this->ServiceNames[] = $serviceNames;

        return $this;
    }

    /**
     * Remove ServiceNames
     *
     * @param \LifeStyle\Tools\CredentialsBundle\Entity\ServiceName $serviceNames
     */
    public function removeServiceName(\LifeStyle\Tools\CredentialsBundle\Entity\ServiceName $serviceNames)
    {
        $this->ServiceNames->removeElement($serviceNames);
    }

    /**
     * Get ServiceNames
     *
     * @return \Doctrine\Common\Collections\Collection 
     */
    public function getServiceNames()
    {
        return $this->ServiceNames;
    }
}
