<?php

namespace LifeStyle\Tools\CredentialsBundle\Entity;

use Doctrine\ORM\Mapping as ORM;

/**
 * ServiceName
 */
class ServiceName
{
    /**
     * @var integer
     */
    private $ServiceNameId;

    /**
     * @var string
     */
    private $ServiceName;

    /**
     * @var integer
     */
    private $ServiceActive;

    /**
     * @var \Doctrine\Common\Collections\Collection
     */
    private $Services;

    /**
     * @var \Doctrine\Common\Collections\Collection
     */
    private $Tokens;

    /**
     * Constructor
     */
    public function __construct()
    {
        $this->Services = new \Doctrine\Common\Collections\ArrayCollection();
        $this->Tokens = new \Doctrine\Common\Collections\ArrayCollection();
    }

    /**
     * Get ServiceNameId
     *
     * @return integer 
     */
    public function getServiceNameId()
    {
        return $this->ServiceNameId;
    }

    /**
     * Set ServiceName
     *
     * @param string $serviceName
     * @return ServiceName
     */
    public function setServiceName($serviceName)
    {
        $this->ServiceName = $serviceName;

        return $this;
    }

    /**
     * Get ServiceName
     *
     * @return string 
     */
    public function getServiceName()
    {
        return $this->ServiceName;
    }

    /**
     * Set ServiceActive
     *
     * @param integer $serviceActive
     * @return ServiceName
     */
    public function setServiceActive($serviceActive)
    {
        $this->ServiceActive = $serviceActive;

        return $this;
    }

    /**
     * Get ServiceActive
     *
     * @return integer 
     */
    public function getServiceActive()
    {
        return $this->ServiceActive;
    }

    /**
     * Add Services
     *
     * @param \LifeStyle\Tools\CredentialsBundle\Entity\Service $services
     * @return ServiceName
     */
    public function addService(\LifeStyle\Tools\CredentialsBundle\Entity\Service $services)
    {
        $this->Services[] = $services;

        return $this;
    }

    /**
     * Remove Services
     *
     * @param \LifeStyle\Tools\CredentialsBundle\Entity\Service $services
     */
    public function removeService(\LifeStyle\Tools\CredentialsBundle\Entity\Service $services)
    {
        $this->Services->removeElement($services);
    }

    /**
     * Get Services
     *
     * @return \Doctrine\Common\Collections\Collection 
     */
    public function getServices()
    {
        return $this->Services;
    }

    /**
     * Add Tokens
     *
     * @param \LifeStyle\Tools\CredentialsBundle\Entity\Token $tokens
     * @return ServiceName
     */
    public function addToken(\LifeStyle\Tools\CredentialsBundle\Entity\Token $tokens)
    {
        $this->Tokens[] = $tokens;

        return $this;
    }

    /**
     * Remove Tokens
     *
     * @param \LifeStyle\Tools\CredentialsBundle\Entity\Token $tokens
     */
    public function removeToken(\LifeStyle\Tools\CredentialsBundle\Entity\Token $tokens)
    {
        $this->Tokens->removeElement($tokens);
    }

    /**
     * Get Tokens
     *
     * @return \Doctrine\Common\Collections\Collection 
     */
    public function getTokens()
    {
        return $this->Tokens;
    }
}
