<?php

namespace LifeStyle\Tools\CredentialsBundle\Entity;

use Doctrine\ORM\Mapping as ORM;

/**
 * Token
 */
class Token
{
    /**
     * @var string
     */
    private $ServiceToken;

    /**
     * @var string
     */
    private $ServiceToken2Ip;

    /**
     * @var integer
     */
    private $AllowedCallsPerDay;

    /**
     * @var \DateTime
     */
    private $ValidUntil;

    /**
     * @var integer
     */
    private $Blocked;

    /**
     * @var string
     */
    private $BlockedReason;

    /**
     * @var string
     */
    private $Description;

    /**
     * @var \Doctrine\Common\Collections\Collection
     */
    private $TokenUsages;

    /**
     * @var \Doctrine\Common\Collections\Collection
     */
    private $ServiceNames;

    /**
     * Constructor
     */
    public function __construct()
    {
        $this->TokenUsages = new \Doctrine\Common\Collections\ArrayCollection();
        $this->ServiceNames = new \Doctrine\Common\Collections\ArrayCollection();
    }

    /**
     * Set ServiceToken
     *
     * @param string $serviceToken
     * @return Token
     */
    public function setServiceToken($serviceToken)
    {
        $this->ServiceToken = $serviceToken;

        return $this;
    }

    /**
     * Get ServiceToken
     *
     * @return string 
     */
    public function getServiceToken()
    {
        return $this->ServiceToken;
    }

    /**
     * Set ServiceToken2Ip
     *
     * @param string $serviceToken2Ip
     * @return Token
     */
    public function setServiceToken2Ip($serviceToken2Ip)
    {
        $this->ServiceToken2Ip = $serviceToken2Ip;

        return $this;
    }

    /**
     * Get ServiceToken2Ip
     *
     * @return string 
     */
    public function getServiceToken2Ip()
    {
        return $this->ServiceToken2Ip;
    }

    /**
     * Set AllowedCallsPerDay
     *
     * @param integer $allowedCallsPerDay
     * @return Token
     */
    public function setAllowedCallsPerDay($allowedCallsPerDay)
    {
        $this->AllowedCallsPerDay = $allowedCallsPerDay;

        return $this;
    }

    /**
     * Get AllowedCallsPerDay
     *
     * @return integer 
     */
    public function getAllowedCallsPerDay()
    {
        return $this->AllowedCallsPerDay;
    }

    /**
     * Set ValidUntil
     *
     * @param \DateTime $validUntil
     * @return Token
     */
    public function setValidUntil($validUntil)
    {
        $this->ValidUntil = $validUntil;

        return $this;
    }

    /**
     * Get ValidUntil
     *
     * @return \DateTime 
     */
    public function getValidUntil()
    {
        return $this->ValidUntil;
    }

    /**
     * Set Blocked
     *
     * @param integer $blocked
     * @return Token
     */
    public function setBlocked($blocked)
    {
        $this->Blocked = $blocked;

        return $this;
    }

    /**
     * Get Blocked
     *
     * @return integer 
     */
    public function getBlocked()
    {
        return $this->Blocked;
    }

    /**
     * Set BlockedReason
     *
     * @param string $blockedReason
     * @return Token
     */
    public function setBlockedReason($blockedReason)
    {
        $this->BlockedReason = $blockedReason;

        return $this;
    }

    /**
     * Get BlockedReason
     *
     * @return string 
     */
    public function getBlockedReason()
    {
        return $this->BlockedReason;
    }

    /**
     * Set Description
     *
     * @param string $description
     * @return Token
     */
    public function setDescription($description)
    {
        $this->Description = $description;

        return $this;
    }

    /**
     * Get Description
     *
     * @return string 
     */
    public function getDescription()
    {
        return $this->Description;
    }

    /**
     * Add TokenUsages
     *
     * @param \LifeStyle\Tools\CredentialsBundle\Entity\TokenUsage $tokenUsages
     * @return Token
     */
    public function addTokenUsage(\LifeStyle\Tools\CredentialsBundle\Entity\TokenUsage $tokenUsages)
    {
        $this->TokenUsages[] = $tokenUsages;

        return $this;
    }

    /**
     * Remove TokenUsages
     *
     * @param \LifeStyle\Tools\CredentialsBundle\Entity\TokenUsage $tokenUsages
     */
    public function removeTokenUsage(\LifeStyle\Tools\CredentialsBundle\Entity\TokenUsage $tokenUsages)
    {
        $this->TokenUsages->removeElement($tokenUsages);
    }

    /**
     * Get TokenUsages
     *
     * @return \Doctrine\Common\Collections\Collection 
     */
    public function getTokenUsages()
    {
        return $this->TokenUsages;
    }

    /**
     * Add ServiceNames
     *
     * @param \LifeStyle\Tools\CredentialsBundle\Entity\ServiceName $serviceNames
     * @return Token
     */
    public function addServiceName(\LifeStyle\Tools\CredentialsBundle\Entity\ServiceName $serviceNames)
    {
        $this->ServiceNames[] = $serviceNames;

        return $this;
    }

    /**
     * Remove ServiceNames
     *
     * @param \LifeStyle\Tools\CredentialsBundle\Entity\ServiceName $serviceNames
     */
    public function removeServiceName(\LifeStyle\Tools\CredentialsBundle\Entity\ServiceName $serviceNames)
    {
        $this->ServiceNames->removeElement($serviceNames);
    }

    /**
     * Get ServiceNames
     *
     * @return \Doctrine\Common\Collections\Collection 
     */
    public function getServiceNames()
    {
        return $this->ServiceNames;
    }
}
