<?php

/**
 * Webservice database handler
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is protected by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2015 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 */

namespace LifeStyle\Tools\DbLogBundle\Entity;

use Doctrine\ORM\Mapping as ORM;

/**
 *
 * @ORM\Entity(repositoryClass="LifeStyle\Tools\DbLogBundle\Entity\SystemLogRepository")
 * @ORM\Table(
 *     name="system_log",
 *     indexes={
 *         @ORM\Index(name="idx_level", columns={"level","createdTime","created","modified","extras","channel"}),
 *         @ORM\Index(name="idx_channel", columns={"channel","createdTime","created","modified","extras","level"}),
 *         @ORM\Index(name="idx_extras", columns={"extras","createdTime","created","modified","channel","level"}),
 *         @ORM\Index(name="idx_createdTime", columns={"createdTime","created","modified","extras","channel","level"})
 *     }
 * ) * @ORM\HasLifecycleCallbacks
 */
class SystemLog
{

    /**
     * @ORM\Id
     * @ORM\Column(type="string", nullable=false, length=64)
     * @ORM\GeneratedValue(strategy="NONE")
     */
    private $id;

    /**
     * @ORM\Column(type="integer", nullable=true)
     */
    private $level;

    /**
     * @ORM\Column(type="string", length=32, nullable=true)
     */
    private $channel;

    /**
     * @ORM\Column(type="string", length=32, nullable=true)
     */
    private $extras;
    
    /**
     * @ORM\Column(type="datetime")
     */
    private $modified;

    /**
     * @ORM\Column(type="datetime")
     */
    private $created;

    /**
     * @ORM\Column(type="bigint", options={"unsigned"=true})
     */
    private $createdTime;

    /**
     * @ORM\OneToOne(targetEntity="SystemLogData", mappedBy="systemLog")
     */
    private $systemLogData;

    /**
     * Generate id on construct
     */
    public function __construct()
    {
        $this->id = hash('sha256', mt_rand() . '#' . microtime());
    }

    /**
     * @ORM\PreUpdate
     */
    public function setModifiedValue()
    {
        $this->modified = new \DateTime();
    }

    /**
     * @ORM\PrePersist
     */
    public function setCreatedValue()
    {
        $this->modified = new \DateTime();
        $this->created = new \DateTime();
        $this->createdTime = microtime(true) * 10;
    }

    /**
     * Get id
     *
     * @return string
     */
    public function getId()
    {
        return $this->id;
    }

    /**
     * Set log
     *
     * @param string $log
     * @return SystemLog
     */
    public function setLog($log)
    {
        $this->log = $log;

        return $this;
    }

    /**
     * Get log
     *
     * @return string
     */
    public function getLog()
    {
        return $this->log;
    }

    /**
     * Set serverData
     *
     * @param string $serverData
     * @return SystemLog
     */
    public function setServerData($serverData)
    {
        $this->serverData = $serverData;

        return $this;
    }

    /**
     * Get serverData
     *
     * @return string
     */
    public function getServerData()
    {
        return $this->serverData;
    }

    /**
     * Set level
     *
     * @param string $level
     * @return SystemLog
     */
    public function setLevel($level)
    {
        $this->level = $level;

        return $this;
    }

    /**
     * Get level
     *
     * @return string
     */
    public function getLevel()
    {
        return $this->level;
    }

    /**
     * Set channel
     *
     * @param string $channel
     * @return SystemLog
     */
    public function setChannel($channel)
    {
        $this->channel = $channel;

        return $this;
    }

    /**
     * Get level
     *
     * @return string
     */
    public function getChannel()
    {
        return $this->channel;
    }

    /**
     * Set channel
     *
     * @param string $extras
     * @return SystemLog
     */
    public function setExtras($extras)
    {
        $this->extras = $extras;

        return $this;
    }

    /**
     * Get extras
     *
     * @return string
     */
    public function getExtras()
    {
        return $this->extras;
    }

    /**
     * Set modified
     *
     * @param \DateTime $modified
     * @return SystemLog
     */
    public function setModified($modified)
    {
        $this->modified = $modified;

        return $this;
    }

    /**
     * Get modified
     *
     * @return \DateTime
     */
    public function getModified()
    {
        return $this->modified;
    }

    /**
     * Set created
     *
     * @param \DateTime $created
     * @return SystemLog
     */
    public function setCreated($created)
    {
        $this->created = $created;

        return $this;
    }

    /**
     * Get created
     *
     * @return \DateTime
     */
    public function getCreated()
    {
        return $this->created;
    }

    /**
     * Set createdTime
     *
     * @param int $createdTime
     * @return SystemLog
     */
    public function setCreatedTime($createdTime)
    {
        $this->createdTime = $createdTime;

        return $this;
    }

    /**
     * Get createdTime
     *
     * @return int
     */
    public function getCreatedTime()
    {
        return $this->createdTime;
    }

    /**
     * Set log data
     *
     * @param SystemLogData $systemLogData
     * @return SystemLog
     */
    public function setSystemLogData(SystemLogData $systemLogData = null)
    {
        $this->systemLogData = $systemLogData;

        return $this;
    }

    /**
     * Get log data
     *
     * @return SystemLogData 
     */
    public function getSystemLogData()
    {
        return $this->systemLogData;
    }

}
