<?php

/**
 * Webservice database handler
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is protected by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2015 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 */

namespace LifeStyle\Tools\DbLogBundle\Entity;

use Doctrine\ORM\Mapping as ORM;

/**
 * @ORM\Entity(repositoryClass="LifeStyle\Tools\DbLogBundle\Entity\SystemLogRepository")
 * @ORM\Table(name="system_log_data")
 * @ORM\HasLifecycleCallbacks
 */
class SystemLogData
{

    /**
     * @ORM\Id
     * @ORM\Column(type="string", nullable=false, length=64)
     * @ORM\GeneratedValue(strategy="NONE")
     */
    private $id;

    /**
     * @ORM\OneToOne(targetEntity="SystemLog", inversedBy="systemLogData")
     * @ORM\JoinColumn(name="id", referencedColumnName="id", onDelete="CASCADE")
     */
    private $systemLog;

    /**
     * @ORM\Column(type="text", nullable=true)
     */
    private $log;

    /**
     * @ORM\Column(type="text", nullable=true)
     */
    private $serverData;

    /**
     * Set id
     *
     * @param string $id
     * @return SystemLogData
     */
    public function setId($id)
    {
        $this->id = $id;

        return $this;
    }

    /**
     * @return string
     */
    public function getId()
    {
        return $this->id;
    }

    /**
     * @param string $log
     * @return SystemLogData
     */
    public function setLog($log)
    {
        $this->log = $log;

        return $this;
    }

    /**
     * @return string
     */
    public function getLog()
    {
        return $this->log;
    }

    /**
     * @param string $serverData
     * @return SystemLogData
     */
    public function setServerData($serverData)
    {
        $this->serverData = $serverData;

        return $this;
    }

    /**
     * @return string
     */
    public function getServerData()
    {
        return $this->serverData;
    }

    /**
     * @param SystemLog $systemLog
     * @return SystemLogData
     */
    public function setSystemLog(SystemLog $systemLog = null)
    {
        $this->systemLog = $systemLog;

        return $this;
    }

    /**
     * @return SystemLog
     */
    public function getSystemLog()
    {
        return $this->systemLog;
    }
}
