<?php
/**
 * Webservice route configuration in annotation
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is protected by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2015 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 */

namespace LifeStyle\Tools\WebserviceBundle\Configuration;

use Sensio\Bundle\FrameworkExtraBundle\Configuration\ConfigurationAnnotation;

/**
 * Webservice route configuration
 * 
 * @Annotation
 */
class WsRoute extends ConfigurationAnnotation
{

    /**
     * Controller name
     * 
     * @var string
     */
    protected $controller;

    /**
     * Action name
     * 
     * @var string
     */
    protected $action;

    /**
     * Set controller name
     * 
     * @param string $controller
     * @return WsRoute
     */
    public function setController($controller)
    {
        $this->controller = (string) $controller;

        return $this;
    }

    /**
     * Get controller name
     * 
     * @return string
     */
    public function getController()
    {
        return $this->controller;
    }

    /**
     * Set action name
     * 
     * @param string $action
     * @return WsRoute
     */
    public function setAction($action)
    {
        $this->action = (string) $action;

        return $this;
    }

    /**
     * Get action name
     * 
     * @return string
     */
    public function getAction()
    {
        return $this->action;
    }

    /**
     * Set values
     * 
     * @param array $values
     * @throws \RuntimeException
     */
    public function setValue($values)
    {
        foreach ($values as $k => $v) {
            if (!method_exists($this, $name = 'set' . $k)) {
                throw new \RuntimeException(sprintf('Unknown key "%s" for annotation "@%s".', $k, get_class($this)));
            }

            $this->$name($v);
        }
    }

    /**
     * Returns the annotation alias name.
     *
     * @return string
     * @see ConfigurationInterface
     */
    public function getAliasName()
    {
        return 'wsRoute';
    }

    /**
     * Only one validation is allowed
     *
     * @return bool
     * @see ConfigurationInterface
     */
    public function allowArray()
    {
        return false;
    }

}
