<?php
/**
 * Webservice request validation in annotation
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is protected by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2015 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 */

namespace LifeStyle\Tools\WebserviceBundle\DependencyInjection;

use Symfony\Component\DependencyInjection\ContainerBuilder;
use Symfony\Component\Config\FileLocator;
use Symfony\Component\HttpKernel\DependencyInjection\Extension;
use Symfony\Component\DependencyInjection\Loader;

/**
 * This is the class that loads and manages your bundle configuration
 *
 * To learn more see {@link http://symfony.com/doc/current/cookbook/bundles/extension.html}
 */
class LifeStyleToolsWebserviceExtension extends Extension
{

    /**
     * {@inheritdoc}
     */
    public function load(array $configs, ContainerBuilder $container)
    {
        $configuration = new Configuration();
        $config = $this->processConfiguration($configuration, $configs);

        $loader = new Loader\YamlFileLoader($container, new FileLocator(__DIR__ . '/../Resources/config'));
        $loader->load('services.yml');

        $annotationsToLoad = array();

        if ($config['wscontroller']['annotations']) {
            $annotationsToLoad[] = 'wscontroller.yml';

            $this->addClassesToCompile(array(
                'LifeStyle\Tools\WebserviceBundle\EventListener\\WsControllerListener',
            ));
        }

        if ($config['wssecurity']['annotations']) {
            $annotationsToLoad[] = 'wssecurity.yml';

            $this->addClassesToCompile(array(
                'LifeStyle\Tools\WebserviceBundle\EventListener\\WsControllerListener',
            ));
        }

        if ($annotationsToLoad) {
            $loader->load('wsrouting.yml');

            foreach ($annotationsToLoad as $configFile) {
                $loader->load($configFile);
            }
        }
    }

}
