<?php
/**
 * Track id service 
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is protected by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2015 Lifestyle Webconsulting GmbH
 * @version    $Id:$
 * @link       http://www.life-style.de
 */

namespace LifeStyle\Tools\WebserviceBundle\Error;

/**
 * Track id service
 */
class TrackId
{

    /**
     * Track id
     * 
     * @var string
     */
    protected $trackId;

    /**
     * Constructor
     */
    public function __construct()
    {
        $this->trackId = substr(md5(uniqid(rand(), true)), 0, 10);
    }

    /**
     * Get track id
     * 
     * @return string
     */
    public function getTrackId()
    {
        return $this->trackId;
    }

    /**
     * Process record for logger
     * 
     * @param array $record
     * @return array
     */
    public function processRecord(array $record)
    {
        // Remove any passwords from message
        $record['message'] = preg_replace('#<Password>.*</Password>#Ui', '<Password>***</Password>', $record['message']);

        // Add track-id
        $record['extra']['token'] = $this->getTrackId();

        return $record;
    }
}
