<?php

/**
 * Webservice credentials filter event
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is protected by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2015 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 */

namespace LifeStyle\Tools\WebserviceBundle\Event;

use Symfony\Component\EventDispatcher\Event;

/**
 * Webservice credentials filter event
 */
class FilterCredentialsEvent extends Event
{

    /**
     * Current controller
     * 
     * @var string
     */
    protected $controllerName;

    /**
     * Current action
     * 
     * @var string
     */
    protected $actionName;

    /**
     * @var string
     */
    protected $remoteIp;

    /**
     * Credentials
     * 
     * @var \SimpleXMLElement
     */
    protected $credentials;

    /**
     * Constructor
     * 
     * @param \SimpleXMLElement $xmlRequest
     */
    public function __construct($controllerName, $actionName, \SimpleXMLElement $xmlRequest = null, $remoteIp = null)
    {
        $this->controllerName = (string) $controllerName;
        $this->actionName = (string) $actionName;
        $this->credentials = $xmlRequest;
        $this->remoteIp = $remoteIp;
    }

    /**
     * Get current controller name
     * 
     * @return string
     */
    public function getControllerName()
    {
        return $this->controllerName;
    }

    /**
     * Get current action name
     * 
     * @return string
     */
    public function getActionName()
    {
        return $this->actionName;
    }

    /**
     * Get whole credentials element
     * 
     * @return \SimpleXMLElement The credentials element
     */
    public function getCredentials()
    {
        return $this->credentials;
    }

    /**
     * @return string
     */
    public function getRemoteIp()
    {
        return $this->remoteIp;
    }
    

    /**
     * Get the service provider element
     * 
     * @return \SimpleXMLElement|null The service provider elemement, null if not exists
     */
    public function getServiceProvider()
    {
        return null !== $this->credentials && isset($this->credentials->ServiceProvider) ? $this->credentials->ServiceProvider : null;
    }

    /**
     * Get the service trigger element
     * 
     * @return \SimpleXMLElement|null The service trigger elemement, null if not exists
     */
    public function getServiceTrigger()
    {
        return null !== $this->credentials && isset($this->credentials->ServiceTrigger) ? $this->credentials->ServiceTrigger : null;
    }

    /**
     * Get the service country element
     * 
     * @return \SimpleXMLElement|null The service country elemement, null if not exists
     */
    public function getServiceCountry()
    {
        return null !== $this->credentials && isset($this->credentials->ServiceCountry) ? $this->credentials->ServiceCountry : null;
    }

}