<?php

/**
 * Api user controller
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is protected by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2014 Lifestyle Webconsulting GmbH
 * @version    $Id:$
 * @link       http://www.life-style.de
 */

namespace Sso\ApiBundle\Api\Controller;

use Sso\ApiBundle\Api\Error\Type\External as ExternalError;
use Sso\ApiBundle\Api\Response\Builder as XmlResponse;

/**
 * Api user controller
 */
class LanguageController extends AbstractController
{

    /**
     * Returns list of available actions
     * 
     * @return array
     */
    protected function _getActions()
    {
        return array(
            'Codes',
        );
    }

    /**
     * Get Language Codes
     * 
     * @param \SimpleXMLElement $xmlRequest
     * @param XmlResponse $xmlResponse
     */
    protected function codes(\SimpleXMLElement $xmlRequest, XmlResponse $xmlResponse)
    {

        $requestModel = $this->modelFactory->request()->language()->codes($xmlRequest);
        $languageId = $requestModel->getLanguageId();
        
        if (!$requestModel->hasErrors() && !($languageArray = $this->dbM->language()->getLanguagesByLanguage($languageId, $this->apiM))) {
            $requestModel->addError(new ExternalError('la011', 'LanguageNotFound'));
        }
        if (!$requestModel->hasErrors()) {
            // search location
            $requestModel->setLanguageArray($languageArray);
        }
        $this->modelFactory->response($xmlResponse)->language()->codes($requestModel);
    }


}
