<?php

/**
 * Sso API Exceptions 
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is protected by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2014 Lifestyle Webconsulting GmbH
 * @version    $Id:$
 * @link       http://www.life-style.de
 */

namespace Sso\ApiBundle\Api\Exception\Type;

/**
 * Exception class for collection errors and exceptions from webservice
 */
class Webservice extends Base
{

    /**
     * Controller name
     * 
     * @var string
     */
    protected $_controller = 'Unknown';

    /**
     * Action name
     * 
     * @var string
     */
    protected $_action = 'Unknown';

    /**
     * Set controller name
     * 
     * @param string $controller
     */
    public function setController($controller)
    {
        $this->_controller = (string) $controller;
    }

    /**
     * Get controller name
     * 
     * @return string
     */
    public function getController()
    {
        return $this->_controller;
    }

    /**
     * Set controller action name
     * 
     * @param string $action
     */
    public function setAction($action)
    {
        $this->_action = (string) $action;
    }

    /**
     * Get controller action name
     * 
     * @return string
     */
    public function getAction()
    {
        return $this->_action;
    }

}
