<?php

/**
 * User: sb
 * Date: 17.11.2014
 * Time: 11:48
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH   * (Aschaffenburg, Germany)
 * and is protected by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2014 Lifestyle Webconsulting GmbH
 * @version    $Id$
 * @link       www.life-style.de
 */

namespace Sso\ApiBundle\Api\Translator;

use Sso\ApiBundle\Api;
use Symfony\Component\Intl\Locale\Locale;
use Symfony\Component\Intl\Intl;

class Locales
{

    /**
     *
     * @var Api\Manager
     */
    protected $apiM;

    /**
     * Constructor
     * 
     * @param Api\Manager $apiM
     */
    public function __construct(Api\Manager $apiM)
    {
        $this->apiM = $apiM;
    }

      /**
     * 
     * @return array
     */
    public function getLocales()
    {

        $locales = Intl::getLocaleBundle()->getLocales();

        return $locales;
    }
    
    /**
     * Returns the name of a locale.
     *
     * @param string $locale The locale to return the name of (e.g. "de_AT").
     * @param string $displayLocale   Optional. The locale to return the name in.
     *                         Defaults to {@link \Locale::getDefault()}.
     *
     * @return string|null The name of the locale or NULL if not found.
     */
    public function getLocaleName($locale, $displayLocale = null)
    {
        $localeObject = new Locale();
        $localeObject->setDefault($displayLocale);
        
        $locales = Intl::getLocaleBundle()->getLocaleName($locale);

        return $locales;
    }

}
