<?php

/**
 * User: sb
 * Date: 17.11.2014
 * Time: 11:48
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH   * (Aschaffenburg, Germany)
 * and is protected by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2014 Lifestyle Webconsulting GmbH
 * @version    $Id$
 * @link       www.life-style.de
 */

namespace Sso\ApiBundle\Api\Translator;

use Sso\ApiBundle\Api;
use Symfony\Component\Intl\Locale\Locale;
use Symfony\Component\Intl\Intl;

class Timezones
{

    /**
     *
     * @var Api\Manager
     */
    protected $apiM;

    /**
     * Constructor
     * 
     * @param Api\Manager $apiM
     */
    public function __construct(Api\Manager $apiM)
    {
        $this->apiM = $apiM;
    }

    /**
     * 
     * @return array
     */
    public function getTimezones()
    {

        $timeZonesArray = array();
        $timeZones = \DateTimeZone::listIdentifiers();

        foreach ($timeZones as $key => $value) {
            $tmp = array();
            $tmp['name'] = $value;
            $tz = new \DateTimeZone($value);
            $tzArray = $tz->getLocation();
            $tmp['countryCode'] = $tzArray['country_code'];
            $tmp['latitude'] = $tzArray['latitude'];
            $tmp['longitude'] = $tzArray['longitude'];
            $tmp['comments'] = $tzArray['comments'];
            $timeZonesArray[] = $tmp;
        }
        return $timeZonesArray;
    }

}
