<?php

/**
 * ServiceProvider database manager 
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is protected by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2014 Lifestyle Webconsulting GmbH
 * @version    $Id:$
 * @link       http://www.life-style.de
 */

namespace Sso\ApiBundle\Database\ServiceProvider;

use \Doctrine\ORM\EntityManager;
use Symfony\Component\Validator\Validator\RecursiveValidator as Validator;

/**
 * ServiceProvider database manager
 */
class Manager
{

    /**
     * List of databases
     * 
     * @var array
     */
    protected $_db = array();

    /**
     * Entity manager
     * 
     * @var \Doctrine\ORM\EntityManager
     */
    protected $_entityManager;

    /**
     * Validator
     * 
     * @var Validator
     */
    protected $validator;

    /**
    /**
     * Construtor
     * 
     * @param \Doctrine\ORM\EntityManager $entityManager
     */
    public function __construct(EntityManager $entityManager, Validator $validator)
    {
        $this->_entityManager = $entityManager;
        $this->validator = $validator;
    }

    /**
     * 
     * @return \Sso\ApiBundle\Database\ServiceProvider\Token
     */
    public function token()
    {
        return $this->_getDatabase('Token');
    }

    /**
     * 
     * @return \Sso\ApiBundle\Database\ServiceProvider\TokenUsage
     */
    public function tokenUsage()
    {
        return $this->_getDatabase('TokenUsage');
    }

    /**
     * 
     * @return \Sso\ApiBundle\Database\ServiceProvider\Service
     */
    public function service()
    {
        return $this->_getDatabase('Service');
    }

    /**
     * 
     * @return \Sso\ApiBundle\Database\ServiceProvider\ServiceName
     */
    public function serviceName()
    {
        return $this->_getDatabase('ServiceName');
    }

    /**
     * 
     * @return \Sso\ApiBundle\Database\ServiceProvider\Log
     */
    public function log()
    {
        return $this->_getDatabase('Log');
    }

    /**
     * 
     * @param string $class
     * @return Base Database
     */
    protected function _getDatabase($class)
    {
        $class = __NAMESPACE__ . '\\' . $class;
        return isset($this->_db[$class]) ? $this->_db[$class] : ($this->_db[$class] = new $class($this->_entityManager, $this->validator));
    }

}
