<?php

/**
 * ServiceProviders service-name database handler
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is protected by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2014 Lifestyle Webconsulting GmbH
 * @version    $Id:$
 * @link       http://www.life-style.de
 */

namespace Sso\ApiBundle\Database\ServiceProvider;

/**
 * ServiceProviders service-name database handler
 */
class ServiceName extends Base
{
    /**
     * List of all service names
     * @return array
     */
    public function getAll()
    {
        return $this->_entityManager->getRepository('LifeStyle\Tools\CredentialsBundle\Entity\ServiceName')->findAll();
    }

    /**
     * List of all service names
     * @return array
     */
    public function getOne($serviceNameId)
    {
        return $this->_entityManager->getRepository('LifeStyle\Tools\CredentialsBundle\Entity\ServiceName')->findOneBy(['ServiceNameId'=>$serviceNameId]);
    }
}
