<?php

/**
 * ServiceProviders token-usage database handler 
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is protected by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2015 Lifestyle Webconsulting GmbH
 * @version    $Id:$
 * @link       http://www.life-style.de
 */

namespace Sso\ApiBundle\Database\ServiceProvider;

use LifeStyle\Tools\CredentialsBundle\Entity\TokenUsage as ModelTokenUsage;
use Sso\ApiBundle\Api\Exception\Type\Api as ApiException;

/**
 * ServiceProviders token-usage database handler
 */
class TokenUsage extends Base
{

    /**
     * Current item
     * 
     * @var ModelTokenUsage
     */
    protected $_usageModel;

    /**
     * List of all token usages
     * 
     * @return array
     */
    public function getAll()
    {
        return $this->_entityManager->getRepository('LifeStyle\Tools\CredentialsBundle\Entity\TokenUsage')->findBy(array(), array('Date' => 'desc'));
    }

    /**
     * Set remote ip
     * 
     * @param string $ipAddress
     */
    public function setIp($ipAddress)
    {
        $this->_getModel()->setIp($ipAddress);
        $this->_saveModel();
    }

    /**
     * Set controller name
     * 
     * @param string $controllerName
     */
    public function setController($controllerName)
    {
        $this->_getModel()->setController($controllerName);
        $this->_saveModel();
    }

    /**
     * Set action name
     * 
     * @param string $actionName
     */
    public function setAction($actionName)
    {
        $this->_getModel()->setAction($actionName);
        $this->_saveModel();
    }

    /**
     * Set service token
     * 
     * @param ModelTokenUsage $token
     */
    public function setToken($token)
    {
        $this->_getModel()->setToken($token);
        $this->_saveModel();
    }

    /**
     * Save current model
     */
    protected function _saveModel()
    {
        $model = $this->_getModel();
        if ($model->isValid()) {
            $this->saveTokenUsage($model);
        }
    }

    /**
     * Get token usage model
     * 
     * @return ModelTokenUsage
     */
    protected function _getModel()
    {
        if (null === $this->_usageModel) {
            $this->_usageModel = new ModelTokenUsage();
            $this->_usageModel->initUsageId();
            $this->_usageModel->setDate(new \DateTime());
            $this->_usageModel->setTrackId(ApiException::getTrackId());
        }
        return $this->_usageModel;
    }

    /**
     * Save token usage model
     * 
     * @param ModelTokenUsage $modelTokenUsage
     */
    public function saveTokenUsage(ModelTokenUsage $modelTokenUsage)
    {
        $this->_entityManager->persist($modelTokenUsage);
        $this->_entityManager->flush($modelTokenUsage);
    }

    /**
     * 
     * @return \Doctrine\ORM\EntityRepository
     */
    public function getRepository()
    {
        return $this->_entityManager->getRepository('LifeStyle\Tools\CredentialsBundle\Entity\TokenUsage');
    }
}
