<?php

/**
 * User: sb
 * Date: 14.11.2014
 * Time: 11:48
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH   * (Aschaffenburg, Germany)
 * and is protected by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2014 Lifestyle Webconsulting GmbH
 * @version    $Id$
 * @link       www.life-style.de
 */

namespace Sso\ApiBundle\Database\Webservice;

use Sso\Webservices\ObjectBundle\Entity\Attribute as ModelAttribute;


/**
 * User database handler
 */
class Attribute extends Base
{

    /**
     * Save user
     *
     * @param ModelUser $typeAttribute
     * @return bool Returns true on success, false on validation failure
     */
    public function saveAttribute(ModelAttribute $typeAttribute)
    {
        // Do default validation
//        $typeAttribute->setValidator($this->validator);
//        if (!$typeAttribute->isValid()) {
//            return false;
//        }

        $this->_entityManager->persist($typeAttribute);
        $this->_entityManager->flush($typeAttribute);

        return true;
    }

    /**
     * Delete user
     *
     * @param ModelLocation $typeLocation
     * @return bool True on success
     */
    public function deleteAttribute(ModelAttribute $typeAttribute)
    {
        $typeAttribute->setValidator($this->validator);
        if (!$typeAttribute->validate(array('Attribute_Delete'))) {
            return false;
        }
        $this->_entityManager->remove($typeAttribute);
        $this->_entityManager->flush($typeAttribute);

        return true;
    }

    /**
     *
     * @param string $attributeId
     * @return ModelAttribute|null
     */
    public function getAttributeById($attributeId)
    {
        return $this->getAttributeRepository()->find($attributeId);
    }

    /**
     *
     * @return \Sso\ApiBundle\Entity\Webservice\Attribute
     */
    public function getAttributeRepository()
    {
        return $this->_entityManager->getRepository('Sso\Webservices\ObjectBundle\Entity\Attribute');
    }

    /**
     *
     * @return ModelAttribute
     */
    public function getAttributeModel()
    {
        return new ModelAttribute();
    }

    /**
     * @return array
     */
    public function getAllAttributesArray()
    {
        $resArray = [];
        foreach ($this->getAttributeRepository()->findAll() as $entity) {
            $resArray[$entity->getName()] = $entity->getId();
        }

        return $resArray;
    }

}
