<?php

/**
 * User: sb
 * Date: 14.11.2014
 * Time: 11:48
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH   * (Aschaffenburg, Germany)
 * and is protected by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2014 Lifestyle Webconsulting GmbH
 * @version    $Id$
 * @link       www.life-style.de
 */

namespace Sso\ApiBundle\Database\Webservice;

use Sso\Webservices\ObjectBundle\Entity\AttributeGroup as ModelAttributeGroup;

/**
 * User database handler
 */
class AttributeGroup extends Base
{

    /**
     * Save user
     * 
     * @param ModelUser $typeAttributeGroup
     * @return bool Returns true on success, false on validation failure
     */
    public function saveAttributeGroup(ModelAttributeGroup $typeAttributeGroup)
    {
        $this->_entityManager->persist($typeAttributeGroup);
        $this->_entityManager->flush($typeAttributeGroup);

        return true;
    }

    /**
     * Delete user
     * 
     * @param ModelLocation $typeLocation
     * @return bool True on success
     */
    public function deleteAttributeGroup(ModelAttributeGroup $typeAttributeGroup)
    {
        $this->_entityManager->remove($typeAttributeGroup);
        $this->_entityManager->flush($typeAttributeGroup);

        return true;
    }

    /**
     * 
     * @param string $attributeId
     * @return ModelAttributeGroup|null
     */
    public function getAttributeGroupById($attributeId)
    {
        return $this->getAttributeGroupRepository()->find($attributeId);
    }

    /**
     * 
     * @return \Doctrine\ORM\EntityRepository
     */
    public function getAttributeGroupRepository()
    {
        return $this->_entityManager->getRepository('Sso\Webservices\ObjectBundle\Entity\AttributeGroup');
    }

    /**
     * 
     * @return ModelAttributeGroup
     */
    public function getAttributeGroupModel()
    {
        return new ModelAttributeGroup();
    }

}
