<?php

/**
 * User: sb
 * Date: 14.11.2014
 * Time: 11:48
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH   * (Aschaffenburg, Germany)
 * and is protected by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2014 Lifestyle Webconsulting GmbH
 * @version    $Id$
 * @link       www.life-style.de
 */

namespace Sso\ApiBundle\Database\Webservice;

use Sso\Webservices\ObjectBundle\Entity\Attribute as ModelAttribute;


/**
 * User database handler
 */
class Attributes extends Base
{

    /**
     * Save user
     * 
     * @param ModelUser $typeObject
     * @return bool Returns true on success, false on validation failure
     */
    public function saveAttribute(ModelAttribute $typeObject)
    {
        $this->_entityManager->persist($typeObject);
        $this->_entityManager->flush($typeObject);

        return true;
    }

    /**
     * Delete user
     * 
     * @param ModelLocation $typeLocation
     * @return bool True on success
     */
    public function deleteAttribute(ModelAttribute $typeObject)
    {
        // first delete all attribute values
        foreach ($typeObject->getAttributeValues() as $attributeValues) {
            $this->_entityManager->remove($attributeValues);
            $this->_entityManager->flush($attributeValues);
        }
        // now delete attribute
        $this->_entityManager->remove($typeObject);
        $this->_entityManager->flush($typeObject);
        return true;
    }

    /**
     * 
     * @param string $objectId
     * @return AttributenModel|null
     */
    public function getAttributeById($objectId)
    {
        return $this->getAttributeRepository()->find($objectId);
    }

    /**
     * 
     * @return Sso\ApiBundle\Entity\Webservice\Type\Attribute
     */
    public function getAttributeRepository()
    {
        return $this->_entityManager->getRepository('Sso\Webservices\ObjectBundle\Entity\Attribute');
    }

}
