<?php

/**
 * User: sb
 * Date: 14.11.2014
 * Time: 11:48
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH   * (Aschaffenburg, Germany)
 * and is protected by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2014 Lifestyle Webconsulting GmbH
 * @version    $Id$
 * @link       www.life-style.de
 */

namespace Sso\ApiBundle\Database\Webservice;

use Sso\Webservices\LocationBundle\Entity\Country as ModelCountry;
use Sso\ApiBundle\Api;

/**
 * Role database handler
 */
class Country extends Base
{

    /**
     * Save role to database
     * 
     * @param ModelCountry $typeCountry
     * @return bool Returns true on success, false on validation failure
     */
    public function saveCountry(ModelCountry $typeCountry)
    {
        // Do default validation
        $typeCountry->setValidator($this->validator);
        if (!$typeCountry->isValid()) {
            return false;
        }

        $this->_entityManager->persist($typeCountry);
        $this->_entityManager->flush($typeCountry);

        return true;
    }

    /**
     * Delete role from database
     * 
     * @param ModelRole $typeRole
     * @return bool True on success
     */
    public function deleteCountry(ModelCountry $typeCountry)
    {
        $typeCountry->setValidator($this->validator);
        if (!$typeCountry->validate(array('ApplicationRole_Delete'))) {
            return false;
        }

        $this->_entityManager->remove($typeCountry);
        $this->_entityManager->flush($typeCountry);

        return true;
    }

    /**
     * Find country by id
     * 
     * @param string $countryId
     * @return ModelCountry|null
     */
    public function getCountryById($countryId)
    {
        return $this->getCountryRepository()->find($countryId);
    }

    /**
     * ISO 632.2
     * @param \Sso\ApiBundle\Api\Manager $apiM
     * @return boolean
     */
    public function fillCountryWithDefaultData(Api\Manager $apiM)
    {

        // we need a language entity to add it default lan is en

        $langEntity = $apiM->database()->webservice()->language()->getLanguageRepository()->find('en');

        if (empty($langEntity)) {
            return false;
        }

        $countryArray = $apiM->translator()->country()->getCountryNames('en');



        // now we set all languages 
        foreach ($countryArray as $id => $name) {
            $entityCountry = $this->getCountryEntity();
            $entityCountry->setLanguage($langEntity);
            $entityCountry->setName($name);
            $entityCountry->setCode($id);
            $checkNull = $this->getCountryRepository()->findOneBy(array('name' => $name));
            if (empty($checkNull)) {
                // save it
                $this->_entityManager->persist($entityCountry);
                $this->_entityManager->flush($entityCountry);
            }
        }

        return true;
    }

    /**
     * 
     * @param Api\Manager $apiM
     * @param ModelLanguage $langModel
     * @return array
     */
    public function getAllCountries(Api\Manager $apiM, ModelCountry $langModel = null)
    {

        $code = $langModel->getLanguageCode();
        $countriesReworked = array();
        
        if (empty($code)) {
            
            return $this->getCountryRepository()->findAll();
        } else {
            
            $countryResults = $this->getCountryRepository()->findAll();
            foreach ($countryResults as $countryHit) {
                $newName = $apiM->translator()->country()->getCountryName($countryHit->getCode(), $code);
                $countryHit->setName($newName);
                $countriesReworked[] = $countryHit;
            }

            return $countriesReworked;
        }
    }

    /**
     * 
     * @return ModelCountry
     */
    public function getCountryEntity()
    {

        return new ModelCountry($this->validator);
    }

    /**
     * 
     * @return Sso\Webservices\LocationBundle\Entity\Country
     */
    public function getCountryRepository()
    {
        return $this->_entityManager->getRepository('Sso\Webservices\LocationBundle\Entity\Country');
    }

}
