<?php

/**
 * User: sb
 * Date: 14.11.2014
 * Time: 11:48
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH   * (Aschaffenburg, Germany)
 * and is protected by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2014 Lifestyle Webconsulting GmbH
 * @version    $Id$
 * @link       www.life-style.de
 */

namespace Sso\ApiBundle\Database\Webservice;

use Symfony\Component\Validator\Validator\RecursiveValidator as Validator;
use Doctrine\ORM\EntityManager;
use Sso\ApiBundle\Database\Webservice\Entity;

/**
 * Webservice database manager
 */
class Manager
{

    /**
     * List of databases
     * 
     * @var array
     */
    protected $_db = array();

    /**
     * Entity manager
     * 
     * @var \Doctrine\ORM\EntityManager
     */
    protected $entityManager;

    /**
     * Validator
     * 
     * @var Validator
     */
    protected $validator;

    /**
     * Construtor
     * 
     * @param \Doctrine\ORM\EntityManager $em
     */
    public function __construct(EntityManager $entityManager, Validator $validator)
    {
        $this->entityManager = $entityManager;
        $this->validator = $validator;
    }

    /**
     * 
     * @return \Sso\ApiBundle\Database\Webservice\Object
     */
    public function object()
    {
        return $this->_getDatabase('Object');
    }
    
     /**
     * 
     * @return \Sso\ApiBundle\Database\Webservice\Attributes
     */
    public function attributes()
    {
        return $this->_getDatabase('Attributes');
    }

    /**
     * 
     * @return \Sso\ApiBundle\Database\Webservice\Type
     */
    public function types()
    {
        return $this->_getDatabase('Type');
    }
    
     /**
     * 
     * @return \Sso\ApiBundle\Database\Webservice\AttributeGroup
     */
    public function attributeGroup()
    {
        return $this->_getDatabase('AttributeGroup');
    }
    
     /**
     * 
     * @return \Sso\ApiBundle\Database\Webservice\ObjectValues
     */
    public function objectValues()
    {
        return $this->_getDatabase('ObjectValues');
    }

    /**
     * 
     * @return \Sso\ApiBundle\Database\Webservice\Location
     */
    public function location()
    {
        return $this->_getDatabase('Location');
    }

    /**
     * 
     * @return \Sso\ApiBundle\Database\Webservice\Attribute
     */
    public function attribute()
    {
        return $this->_getDatabase('Attribute');
    }

    /**
     * 
     * @return \Sso\ApiBundle\Database\Webservice\LocationAttribute
     */
    public function locationattribute()
    {
        return $this->_getDatabase('LocationAttribute');
    }

    /**
     * 
     * @return \Sso\ApiBundle\Database\Webservice\Language
     */
    public function language()
    {
        return $this->_getDatabase('Language');
    }
    
    /**
     * 
     * @return \Sso\ApiBundle\Database\Webservice\ObjectLanguage
     */
    public function objectLanguage()
    {
        return $this->_getDatabase('ObjectLanguage');
    }

    /**
     * 
     * @return \Sso\ApiBundle\Database\Webservice\Timezone
     */
    public function timezone()
    {
        return $this->_getDatabase('Timezone');
    }

    /**
     * 
     * @return \Sso\ApiBundle\Database\Webservice\Country
     */
    public function country()
    {
        return $this->_getDatabase('Country');
    }

    /**
     * 
     * @param string $class
     * @return Base Database
     */
    protected function _getDatabase($class)
    {

        $class = __NAMESPACE__ . '\\' . $class;
        return isset($this->_db[$class]) ? $this->_db[$class] : ($this->_db[$class] = new $class($this->entityManager, $this->validator));
    }

}
