<?php

/**
 * User: sb
 * Date: 14.11.2014
 * Time: 11:48
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH   * (Aschaffenburg, Germany)
 * and is protected by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2014 Lifestyle Webconsulting GmbH
 * @version    $Id$
 * @link       www.life-style.de
 */

namespace Sso\ApiBundle\Database\Webservice;

use Sso\Webservices\ObjectBundle\Entity\Language as ModelLanguage;
use Sso\ApiBundle\Api;

/**
 * User database handler
 */
class ObjectLanguage extends Base
{

    /**
     * Save user
     * 
     * @param ModelLanguage $typeLanguage
     * @return bool Returns true on success, false on validation failure
     */
    public function saveLanguage(ModelLanguage $typeLanguage)
    {
        // Do default validation
        $typeUser->setValidator($this->validator);
        if (!$typeUser->isValid()) {
            return false;
        }

        $this->_entityManager->persist($typeLanguage);
        $this->_entityManager->flush($typeLanguage);

        return true;
    }

    /**
     * ISO 632.2
     * @param \Sso\ApiBundle\Api\Manager $apiM
     * @return boolean
     */
    public function fillLanguageWithDefaultData(Api\Manager $apiM)
    {

        $languagesArray = $apiM->translator()->language()->getLanguageNames();

        $entityLanguage = $this->getLanguageEntity();
        $entityLanguage->setId('all');
        $entityLanguage->setName('NotSet');

        // first we set a default 
        $checkNull = $this->getLanguageById($entityLanguage->getId());


        if (empty($checkNull)) {
            // save it


            $errors = $this->validator->validate($entityLanguage);
            dump($errors);
            $this->_entityManager->persist($entityLanguage);
            $this->_entityManager->flush($entityLanguage);
        }

        // now we set all languages 
        foreach ($languagesArray as $id => $name) {
            $entityLanguage = $this->getLanguageEntity();
            $entityLanguage->setId($id);
            $entityLanguage->setName($name);

            $checkNull = $this->getLanguageById($entityLanguage->getId());
            if (empty($checkNull)) {
                // save it
                $this->_entityManager->persist($entityLanguage);
                $this->_entityManager->flush($entityLanguage);
            }
        }

        return true;
    }

    /**
     * Delete language
     * 
     * @param ModelLanguage $typeLanguage
     * @return bool True on success
     */
    public function deleteLanguage(ModelLanguage $typeLanguage)
    {
        $typeUser->setValidator($this->validator);
        if (!$typeUser->validate(array('User_Delete'))) {
            return false;
        }
        $this->_entityManager->remove($typeLanguage);
        $this->_entityManager->flush($typeLanguage);

        return true;
    }

    /**
     * Find language by language-id
     * 
     * @param string $languageId
     * @return Language|null
     */
    public function getLanguageById($languageId)
    {
        return $this->getLanguageRepository()->find($languageId);
    }

    /**
     * 
     * @param string $langId
     * @param \Sso\ApiBundle\Api\Manager $apiM
     * @return array
     */
    public function getLanguagesByLanguage($langId, Api\Manager $apiM)
    {

        return $apiM->translator()->language()->getLanguageNames($langId);
    }

    /**
     * 
     * @param Api\Manager $apiM
     * @param ModelLanguage $langModel
     * @return array
     */
    public function getAllLanguages(Api\Manager $apiM, ModelLanguage $langModel = null)
    {

        $code = $langModel->getCode();
        $languageReworked = array();
        
        if (empty($code)) {
            return $this->getLanguageRepository()->findAll();
        } else {
            $languageResults = $this->getLanguageRepository()->findAll();
            foreach ($languageResults as $languageHit) {
                $newName = $apiM->translator()->language()->getLanguageName($languageHit->getCode(), $code);
                $languageHit->setName($newName);
                $languageReworked[] = $languageHit;
            }

            return $languageReworked;
        }
    }

    /**
     * 
     * @return Sso\ApiBundle\Entity\Webservice\Type\Location
     */
    public function getLanguageRepository()
    {
        return $this->_entityManager->getRepository('Sso\Webservices\ObjectBundle\Entity\Language');
    }

    public function getLanguageEntity()
    {

        return new ModelLanguage();
    }

}
