<?php

/**
 * User: sb
 * Date: 14.11.2014
 * Time: 11:48
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH   * (Aschaffenburg, Germany)
 * and is protected by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2014 Lifestyle Webconsulting GmbH
 * @version    $Id$
 * @link       www.life-style.de
 */

namespace Sso\ApiBundle\Database\Webservice;

use Sso\Webservices\ObjectBundle\Entity\Type as ModelType;


/**
 * User database handler
 */
class Type extends Base
{

    /**
     * Save user
     * 
     * @param ModelUser $types
     * @return bool Returns true on success, false on validation failure
     */
    public function saveType(ModelType $types)
    {
        $this->_entityManager->persist($types);
        $this->_entityManager->flush($types);

        return true;
    }

    /**
     * Delete user
     * 
     * @param ModelType $types
     * @return bool True on success
     */
    public function deleteType(ModelType $types)
    {
     
        $this->_entityManager->remove($types);
        $this->_entityManager->flush($types);

        return true;
    }

    /**
     * 
     * @param string $typesId
     * @return ModelType|null
     */
    public function find($typesId)
    {
        return $this->getTypeRepository()->find($typesId);
    }

    /**
     * 
     * @return \Doctrine\ORM\EntityRepository
     */
    public function getTypeRepository()
    {
        return $this->_entityManager->getRepository('Sso\Webservices\ObjectBundle\Entity\Type');
    }
    
    /**
     * 
     * @return \Doctrine\ORM\EntityManager
     */
    public function getEntityManager(){
        return $this->_entityManager;
    }
    
    /**
     * 
     * @return ModelType
     */
    public function getEntity(){
        return new ModelType();
    }
    

}
