<?php

/**
 * 
 * @class WsLocationController
 * @author sb
 * 
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is protected by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2015 Lifestyle Webconsulting GmbH
 * @version    $Id:$
 * @link       http://www.life-style.de
 * 
 */

namespace Sso\BackendBundle\Controller;

use Symfony\Component\HttpFoundation\Request;
use Symfony\Component\HttpFoundation\Response;
use Symfony\Component\HttpFoundation\JsonResponse;
use Sso\Webservices\ObjectBundle\Entity;
use Sso\BackendBundle\Form;
// these import the "@Route" and "@Template" annotations
use Sensio\Bundle\FrameworkExtraBundle\Configuration\Route;
use Sensio\Bundle\FrameworkExtraBundle\Configuration\Template;

/**
 * WsLocationController
 */
class ReportingController extends WsAbstractController
{

    /**
     * @Route("/hierarchy/objects", name="_admin_backend_webservice_reporting_objects")
     * @Template()
     */
    public function objectsAction()
    {
       
        $types = $this->databaseManager()->webservice()->types()->getTypeRepository()->findBy(
             array(), 
             array('typeOrder' => 'ASC')
           );
        return array('types' => $types);
    }

   

}
