<?php

/**
 * 
 * @class ServiceController
 * @author sb
 * 
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is protected by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2015 Lifestyle Webconsulting GmbH
 * @version    $Id:$
 * @link       http://www.life-style.de
 * 
 */

namespace Sso\BackendBundle\Controller;

use Symfony\Bundle\FrameworkBundle\Controller\Controller;
use Sensio\Bundle\FrameworkExtraBundle\Configuration\Route;
use Sensio\Bundle\FrameworkExtraBundle\Configuration\Template;

class ServiceController extends WsAbstractController
{


    /**
     * @Route("/list", name="_admin_backend_service")
     * @Template()
     */
    public function listAction()
    {
        return ['services' => $this->databaseManager()->serviceProvider()->service()->getAll()];
    }

   
    
    /**
     * @Route("/add", name="_admin_backend_service_add")
     * @Template()
     */
    public function addAction()
    {
        return array();
    }

    /**
     * @Route("/delete", name="_admin_backend_service_delete")
     * @Template()
     */
    public function deleteAction()
    {
        return array();
    }

    /**
     * @Route("/show", name="_admin_backend_service_show")
     * @Template()
     */
    public function showAction()
    {
        return array();
    }
    
}
