<?php

/**
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is protected by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2018 Lifestyle Webconsulting GmbH
 * @version    $Id:$
 * @link       http://www.life-style.de
 * 
 */

namespace Sso\BackendBundle\Controller;

use Symfony\Component\HttpFoundation\Request;
use Symfony\Component\HttpFoundation\Response;
use Symfony\Component\HttpFoundation\RedirectResponse;
use Sensio\Bundle\FrameworkExtraBundle\Configuration\Route;
use Sensio\Bundle\FrameworkExtraBundle\Configuration\Template;
use Sso\BackendBundle\Form;
use JMS\DiExtraBundle\Annotation\Inject;

/**
 * Class TokenUsageController
 * @package Sso\BackendBundle\Controller
 */
class TokenUsageController extends WsAbstractController
{
    /**
     * @Inject("form.factory")
     * @var \Symfony\Component\Form\FormFactory
     */
    private $formFactory;

    /**
     * @Inject("lexik_form_filter.query_builder_updater")
     * @var \Lexik\Bundle\FormFilterBundle\Filter\FilterBuilderUpdater
     */
    private $lexikFilterUpdater;

    /**
     * @Inject("knp_paginator")
     * @var \Knp\Component\Pager\Paginator
     */
    private $knpPaginator;

    /**
     * logs list
     * 
     * @Route("/", name="_admin_backend_tokenusage_index")
     * 
     * @param Request $request
     * @return Response
     */
    public function indexAction(Request $request)
    {

        $filterBuilder = $this->tokenUsageHandler()->getRepository()->createQueryBuilder('a');
        $form = $this->formFactory->create(Form\TokenUsageFilterType::class);

        $reset = false;
        if ($request->query->has('filter_action') && $request->query->get('filter_action') == 'reset') {
            $reset = true;
        }
        if ($request->query->has($form->getName()) && !$reset) {
            $form->submit($request->query->get($form->getName()));
            $this->lexikFilterUpdater->addFilterConditions($form, $filterBuilder);
        }
        $query = $filterBuilder->getQuery();
        $paginator = $this->knpPaginator;
        $pagination = $paginator->paginate($query, $request->query->get('page', 1), 30);

        return $this->render(
            '@SsoBackend/token_usage/index.html.twig',
            ['form' => $form->createView(), 'pagination' => $pagination]
        );
    }

    /**
     * delete all logs
     * 
     * @Route("/delete", name="_admin_backend_tokenusage_delete")
     * @return Response
     */
    public function deleteAction()
    {
        $classMeta = $this->getDoctrine()->getManager('ServiceProvider')->getClassMetadata('LifeStyle\Tools\CredentialsBundle\Entity\TokenUsage');
        $connection = $this->getDoctrine()->getManager('ServiceProvider')->getConnection('ServiceProvider');
        $dbPlatform = $connection->getDatabasePlatform();
        $connection->query('SET FOREIGN_KEY_CHECKS=0');
        $connection->executeUpdate($dbPlatform->getTruncateTableSql($classMeta->getTableName()));
        $connection->query('SET FOREIGN_KEY_CHECKS=1');
        return $this->redirect($this->generateUrl('_admin_backend_tokenusage_index'));
    }

    /**
     * @return \Sso\WebserviceBundle\Database\ServiceProvider\TokenUsage Database handler for TokenUsage model
     */
    private function tokenUsageHandler()
    {
        return $this->databaseManager()->serviceProvider()->tokenUsage();
    }

}
