<?php

/**
 * 
 * @class WsAbstractController
 * @author sb
 * 
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is protected by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2015 Lifestyle Webconsulting GmbH
 * @version    $Id:$
 * @link       http://www.life-style.de
 * 
 */

namespace Sso\BackendBundle\Controller;

use Symfony\Bundle\FrameworkBundle\Controller\Controller;
use Sso\WebserviceBundle\Entity\Webservice\Type;
use Pagerfanta\Pagerfanta;
use Pagerfanta\View\TwitterBootstrap3View;
use Pagerfanta\Adapter\DoctrineORMAdapter;
use Sso\ApiBundle\Api;
use Sso\ApiBundle\Database;
use Symfony\Component\HttpFoundation\Request;
use Sso\Webservices\ObjectBundle\Database\Manager as ObjectDbM;

/**
 * Class WsAbstractController
 * @package Sso\BackendBundle\Controller
 */
abstract class WsAbstractController extends Controller
{
    /**
     * @return \Sso\ApiBundle\Database\Manager
     */
    protected function databaseManager()
    {
        return $this->apiM()->database();
    }
    
    /**
     * @return Api\Manager
     */
    protected function apiM(){
        
         return $this->container->get('service_api_manager');
    }
    
    /**
     * @return ObjectDbM
     */
    protected function objectDbM()
    {
         return $this->container->get('object_database_manager');
    }

    /**
     * @return \Symfony\Component\Validator\Validator\ValidatorInterface
     */
    protected function validator()
    {
        return $this->container->get('validator');
    }

    /**
     * Add error message to frontend
     * 
     * @param string $message
     */
    protected function addError($message)
    {
        $this->get('session')->getFlashBag()->add('error', $message);
    }
}
