<?php
namespace Sso\BackendBundle\Database;

use Symfony\Component\DependencyInjection\ContainerInterface as Container;
use Doctrine\Bundle\DoctrineBundle\Registry as DoctrineRegistry;
use Doctrine\ORM\EntityManager;

class Manager{

    /**
     * @var array
     */
    protected $facSetter;

    /**
     * @var Container
     */
    protected $container;

    /**
     *
     * @var DoctrineRegistry
     */
    protected $doctrineRegistry;

    /**
     *
     * @var EntityManager
     */
    protected $emBackend;

    /**
     * @param Container $container
     */
    public function __construct(Container $container){
        $this->container = $container;
        $this->doctrineRegistry = $this->container->get('doctrine');
        $this->emBackend = $this->doctrineRegistry->getManager('backend');
    }


    /**
     * @return Repository\Factory
     */
    public function repository(){
        if(!isset($this->facSetter['repository'])){
            $this->facSetter['repository'] = new Repository\Factory($this->doctrineRegistry);
        }
        return $this->facSetter['repository'];
    }

    /**
     * @return Entity\Factory
     */
    public function entity(){
        if(!isset($this->facSetter['entity'])){
            $this->facSetter['entity'] = new Entity\Factory();
        }
        return $this->facSetter['entity'];
    }

    /**
     * @return Data\Factory
     */
    public function data(){
        if(!isset($this->facSetter['data'])){
            $this->facSetter['data'] = new Data\Factory();
        }
        return $this->facSetter['data'];
    }

    /**
     * @return EntityManager
     */
    public function getEntityManger(){
        if(!isset($this->facSetter['getEntityManger'])){
            $this->facSetter['getEntityManger'] = $this->emBackend;
        }
        return $this->facSetter['getEntityManger'];
    }


}