<?php

/**
 * @class TokenType
 * @author sb
 * 
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is protected by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2015 Lifestyle Webconsulting GmbH
 * @version    $Id:$
 * @link       http://www.life-style.de
 */

namespace Sso\BackendBundle\Form;

use Symfony\Component\Form\AbstractType;
use Symfony\Component\Form\FormBuilderInterface;
use Symfony\Component\OptionsResolver\OptionsResolver;
use Symfony\Component\Form\Extension\Core\Type as FormType;

/**
 * Class TokenType
 * @package Sso\BackendBundle\Form
 */
class TokenType extends AbstractType
{
    /**
     * @param FormBuilderInterface $builder
     * @param array $options
     */
    public function buildForm(FormBuilderInterface $builder, array $options)
    {
        $builder->add('ServiceToken')
                ->add('ServiceToken2Ip')
                ->add('AllowedCallsPerDay')
                ->add('ValidUntil')
                ->add('Blocked', FormType\ChoiceType::class, array(
                    'choices' => array(
                        0 => 'No',
                        1 => 'Yes',
                    )
                ))
                ->add('Description');
    }

    /**
     * @param OptionsResolver $resolver
     */
    public function configureOptions(OptionsResolver $resolver)
    {
        $resolver->setDefaults(array(
            'data_class' => 'LifeStyle\Tools\CredentialsBundle\Entity\Token'
        ));
    }

    /**
     * @return string
     */
    public function getName()
    {
        return 'sso_backendbundle_token';
    }
}
