<?php

/**
 *
 * @class TokenType
 * @author sb
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is protected by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2017 Lifestyle Webconsulting GmbH
 * @version    $Id:$
 * @link       http://www.life-style.de
 *
 */

namespace Sso\BackendBundle\Form;

use Symfony\Component\Form\AbstractType;
use Symfony\Component\Form\FormBuilderInterface;
use Symfony\Component\OptionsResolver\OptionsResolver;
use Symfony\Bridge\Doctrine\Form\Type\EntityType;
use Symfony\Component\Form\Extension\Core\Type\TextType;

/**
 * Class WsAttributeGroupType
 * @package Sso\BackendBundle\Form
 */
class WsAttributeGroupType extends AbstractType
{
    /**
     * @param FormBuilderInterface $builder
     * @param array $options
     */
    public function buildForm(FormBuilderInterface $builder, array $options)
    {
        $builder
            ->add('types', EntityType::class, array(
            'class' => 'Sso\Webservices\ObjectBundle\Entity\Type',
            'choice_label' => 'name',
            'required' => true,
            'expanded' => true,
            'multiple' => true,
            'label' => "Object Type"
        ))
            ->add('name', TextType::class);
    }

    /**
     * @param OptionsResolver $resolver
     */
    public function configureOptions(OptionsResolver $resolver)
    {
        $resolver->setDefaults(array(
            'data_class' => 'Sso\Webservices\ObjectBundle\Entity\AttributeGroup'
        ));
    }

    /**
     * @return string
     */
    public function getName()
    {
        return 'sso_backendbundle_attribute_group';
    }
}
