<?php

/**
 * @class WsAttributeType
 * @author sb
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is protected by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2017 Lifestyle Webconsulting GmbH
 * @version    $Id:$
 * @link       http://www.life-style.de
 *
 */

namespace Sso\BackendBundle\Form;

use Sso\Webservices\ObjectBundle\Entity\Attribute;
use Symfony\Bridge\Doctrine\Form\Type\EntityType;
use Symfony\Component\Form\AbstractType;
use Symfony\Component\Form\Extension\Core\Type\CheckboxType;
use Symfony\Component\Form\Extension\Core\Type\CollectionType;
use Symfony\Component\Form\Extension\Core\Type\TextType;
use Symfony\Component\Form\FormBuilderInterface;
use Symfony\Component\OptionsResolver\OptionsResolver;

class WsAttributesType extends AbstractType
{
    /**
     * @param FormBuilderInterface $builder
     * @param array $options
     */
    public function buildForm(FormBuilderInterface $builder, array $options)
    {
        $builder
            ->add('name')
            ->add('mandatory', CheckboxType::class, [
                'required' => false,
                'label' => 'Is mandatory',
                'label_attr' => [
                    'class' => 'checkbox-inline'
                ]
            ])
            ->add('possibleValues', CollectionType::class, [
                'entry_type' => TextType::class,
                'allow_add' => true,
                'allow_delete' => true,
                'prototype' => true,
                'required' => false
            ])
            ->add('defaultValue', TextType::class, [
                'required' => false
            ])
            ->add('translatable', CheckboxType::class, [
                'required' => false,
                'label' => 'Is translatable',
            ])
            ->add('AttributeGroup', EntityType::class, [
                'class' => 'Sso\Webservices\ObjectBundle\Entity\AttributeGroup',
                'choice_label' => 'name',
                'required' => true,
                'label' => 'Attribute Group'
            ]);
    }

    /**
     * @param OptionsResolver $resolver
     */
    public function configureOptions(OptionsResolver $resolver)
    {
        $resolver->setDefaults([
            'data_class' => Attribute::class
        ]);
    }

    /**
     * @return string
     */
    public function getName()
    {
        return 'sso_backendbundle_webserviceattributes';
    }
}
