<?php

/**
 * Class AttributeGroupUpdateType
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is protected by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2015 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 */

namespace Sso\DemoBundle\Form;

use Symfony\Component\Form\AbstractType;
use Symfony\Component\Form\FormBuilderInterface;
use Symfony\Component\OptionsResolver\OptionsResolverInterface;
use Sso\ApiBundle\Api;

/**
 * Class AttributeGroupUpdateType
 *
 * @copyright  2015 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 * @package    Sso\DemoBundle\Form
 */
class AttributeGroupUpdateType extends AbstractType
{

    /**
     * @var Api\Manager
     */
    private $apiM;

    /**
     * @param Api\Manager $apiM
     */
    public function __construct(Api\Manager $apiM)
    {
        $this->apiM = $apiM;
    }

    /**
     * 
     * @param FormBuilderInterface $builder
     * @param array $options
     */
    public function buildForm(FormBuilderInterface $builder, array $options)
    {
        $builder->add('id', 'choice', [
            'choices' => $this->getTypeIds(),
        ]);
    }

    /**
     * @return array
     */
    private function getTypeIds()
    {
        $types = $this->apiM->database()->webservice()->types()->getTypeRepository()->findAll();

        $ids = [];
        foreach ($types as $type) {
            $ids[$type->getId()] = $type->getId();
        }

        return $ids;
    }

    /**
     * 
     * @param OptionsResolverInterface $resolver
     */
    public function setDefaultOptions(OptionsResolverInterface $resolver)
    {
        $resolver->setDefaults(array(
            'data_class' => 'Sso\Webservices\ObjectBundle\Entity\Type',
            'label' => false,
        ));
    }

    /**
     * 
     * @return string
     */
    public function getName()
    {
        return 'sso_webservices_objectbundle_attributegroupupdate';
    }

}
