<?php

namespace Sso\HelpBundle\Tests\Controller;

use Symfony\Bundle\FrameworkBundle\Test\WebTestCase;

class IndexControllerTest extends WebTestCase
{

    public function testIndex()
    {
        $client = static::createClient();

        $crawler = $client->request('GET', '/help/');
        $this->assertTrue($crawler->filter('html:contains("Sample curl request with php")')->count() > 0);
    }

    public function testUser()
    {
        $client = static::createClient();

        $crawler = $client->request('GET', '/help/user');
        $this->assertTrue($crawler->filter('html:contains("User Add")')->count() > 0);
        $this->assertTrue($crawler->filter('html:contains("User Change password")')->count() > 0);
        $this->assertTrue($crawler->filter('html:contains("User Delete")')->count() > 0);
        $this->assertTrue($crawler->filter('html:contains("User Show")')->count() > 0);
        $this->assertTrue($crawler->filter('html:contains("User Update")')->count() > 0);
        $this->assertTrue($crawler->filter('html:contains("User Application Add")')->count() > 0);
        $this->assertTrue($crawler->filter('html:contains("User Application Show")')->count() > 0);
        $this->assertTrue($crawler->filter('html:contains("User Application Delete")')->count() > 0);
        $this->assertTrue($crawler->filter('html:contains("User Application Attribute Set")')->count() > 0);
        $this->assertTrue($crawler->filter('html:contains("User Application Attribute Show")')->count() > 0);
        $this->assertTrue($crawler->filter('html:contains("User Application Attribute Delete")')->count() > 0);
        $this->assertTrue($crawler->filter('html:contains("User Application Role Add")')->count() > 0);
        $this->assertTrue($crawler->filter('html:contains("User Application Role Delete")')->count() > 0);
    }

    public function testApplication()
    {
        $client = static::createClient();

        $crawler = $client->request('GET', '/help/application');
        $this->assertTrue($crawler->filter('html:contains("Application Add")')->count() > 0);
        $this->assertTrue($crawler->filter('html:contains("Application Delete")')->count() > 0);
        $this->assertTrue($crawler->filter('html:contains("Application Attribute Add")')->count() > 0);
        $this->assertTrue($crawler->filter('html:contains("Application Attribute Delete")')->count() > 0);
        $this->assertTrue($crawler->filter('html:contains("Application Role Add")')->count() > 0);
        $this->assertTrue($crawler->filter('html:contains("Application Role Delete")')->count() > 0);
    }

}
