<?php

/**
 * UserIdentifier bundle
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is protected by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2014 Lifestyle Webconsulting GmbH
 * @link	   http://www.life-style.de
 */

namespace Sso\Tools\UserIdentifierBundle\Api;

use Symfony\Component\HttpKernel\Log\LoggerInterface;
use Symfony\Component\DependencyInjection\ContainerInterface as Container;
use Sso\Tools\UserIdentifierBundle\Model\Factory as ModelFactory;
use GuzzleHttp\Client;

/**
 * Api manager
 */
class Manager
{

    /**
     * Symfony container
     * 
     * @var Container
     */
    private $container;

    /**
     * List of objects
     * 
     * @var array
     */
    private $factory = array();

    /**
     * Constructor
     * 
     * @param Container $container
     */
    public function __construct(Container $container)
    {
        $this->container = $container;
    }

    /**
     * The logger
     * 
     * @return LoggerInterface
     */
    public function logger()
    {
        return $this->container->get('logger');
    }

    /**
     * @return ModelFactory
     */
    public function modelFactory()
    {
        return isset($this->factory[__FUNCTION__]) ? $this->factory[__FUNCTION__] : ($this->factory[__FUNCTION__] = new ModelFactory($this->serializer()));
    }

    /**
     * @return Client
     */
    public function client()
    {
        return isset($this->factory[__FUNCTION__]) ? $this->factory[__FUNCTION__] : ($this->factory[__FUNCTION__] = new Client($this->getClientConfiguration()));
    }

    /**
     * @return \JMS\Serializer\Serializer
     */
    public function serializer()
    {
        return $this->container->get('jms_serializer');
    }

    /**
     * @return \Symfony\Component\Stopwatch\Stopwatch
     */
    public function stopWatch(){
        return $this->container->get('debug.stopwatch');
    }

    /**
     * @return boolean
     */
    public function debugEnabled(){
        return $this->container->get('kernel')->getEnvironment() != 'prod';
    }

    /**
     * @return array
     */
    private function getClientConfiguration()
    {
        return array(
            'base_uri' => $this->container->getParameter('sso_tools_user_identifier.client_url')
        );
    }
}