<?php

/**
 * Steps Credentials
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is protected by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2015 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 */

namespace Sso\Tools\UserIdentifierBundle\Model\Request\Node;

use JMS\Serializer\Annotation as Serializer;

/**
 * Steps Credentials
 * 
 * @copyright  Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 */
class Credentials
{

    /**
     * @Serializer\Exclude()
     * @var Factory
     */
    private $nodeFactory;

    /**
     * @Serializer\SerializedName("ServiceProvider")
     * @Serializer\Type("Sso\Tools\UserIdentifierBundle\Model\Request\Node\ServiceProvider")
     * @var ServiceProvider
     */
    private $ServiceProvider;

    /**
     * @Serializer\SerializedName("ServiceTrigger")
     * @Serializer\Type("Sso\Tools\UserIdentifierBundle\Model\Request\Node\ServiceTrigger")
     * @var ServiceTrigger
     */
    private $ServiceTrigger;

    /**
     * @Serializer\SerializedName("ServiceCountry")
     * @Serializer\Type("Sso\Tools\UserIdentifierBundle\Model\Request\Node\ServiceCountry")
     * @var ServiceCountry
     */
    private $ServiceCountry;

    /**
     * 
     * @param Factory $nodeFactory
     */
    public function __construct(Factory $nodeFactory)
    {
        $this->nodeFactory = $nodeFactory;
    }

    /**
     * 
     * @return ServiceProvider
     */
    public function serviceProvider()
    {
        return null !== $this->ServiceProvider ? $this->ServiceProvider : ($this->ServiceProvider = $this->nodeFactory->serviceProvider());
    }

    /**
     * 
     * @return ServiceTrigger
     */
    public function serviceTrigger()
    {
        return null !== $this->ServiceTrigger ? $this->ServiceTrigger : ($this->ServiceTrigger = $this->nodeFactory->serviceTrigger());
    }

    /**
     * 
     * @return ServiceTrigger
     */
    public function serviceCountry()
    {
        return null !== $this->ServiceCountry ? $this->ServiceCountry : ($this->ServiceCountry = $this->nodeFactory->serviceCountry());
    }

}