<?php

/**
 * Steps Factory
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is protected by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2015 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 */

namespace Sso\Tools\UserIdentifierBundle\Model\Response;

use JMS\Serializer\Annotation as Serializer;

/**
 * Steps UserIdentifier
 * 
 * @copyright  Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 */
class UserIdentifier
{

    /**
     * @Serializer\SerializedName("Get")
     * @Serializer\Type("Sso\Tools\UserIdentifierBundle\Model\Response\UserIdentifier\Get")
     * @var UserIdentifier\Get
     */
    private $getAction;

    /**
     * @Serializer\SerializedName("Validate")
     * @Serializer\Type("Sso\Tools\UserIdentifierBundle\Model\Response\UserIdentifier\Validate")
     * @var UserIdentifier\Validate
     */
    private $validateAction;

    /**
     * 
     * @return UserIdentifier\Get
     */
    public function get()
    {
        return $this->getAction;
    }

    /**
     * 
     * @return UserIdentifier\Validate
     */
    public function validate()
    {
        return $this->validateAction;
    }

}