<?php

/**
 * 
 * @class AbstractController
 * @author sb
 * 
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is protected by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2015 Lifestyle Webconsulting GmbH
 * @version    $Id:$
 * @link       http://www.life-style.de
 * 
 */

namespace Sso\Webservices\ObjectBundle\Controller;

use Symfony\Bundle\FrameworkBundle\Controller\Controller;
use Sso\ApiBundle\Api;
use Sso\Webservices\ObjectBundle\Worker\Factory as WorkerFactory;
use Sso\Webservices\ObjectBundle\Database\Manager as ObjectDbM;

class AbstractController extends Controller
{

    /**
     * 
     * @return Api\Manager
     */
    public function apiM()
    {
        return $this->get('service_api_manager');
    }
    
    /**
     * 
     * @return ObjectDbM
     */
    public function objectDbM()
    {
        return $this->get('object_database_manager');
    }

   
     /**
     * @return WorkerFactory
     */
    public function worker()
    {
        if (!isset($this->api['worker'])) {
            $this->api['worker'] = new WorkerFactory($this->apiM());
        }

        return $this->api['worker'];
    }
    
}
