<?php

namespace Sso\Webservices\ObjectBundle\Controller;

use Sensio\Bundle\FrameworkExtraBundle\Configuration\Route;
use Sensio\Bundle\FrameworkExtraBundle\Configuration\Template;
use Sensio\Bundle\FrameworkExtraBundle\Configuration\Method;
use Symfony\Bundle\FrameworkBundle\Controller\Controller;
use Symfony\Component\HttpFoundation\Response;
use Symfony\Component\HttpFoundation\Request;
use Symfony\Component\Stopwatch\Stopwatch;
use LifeStyle\Tools\WebserviceBundle\Configuration\WsRoute;
use LifeStyle\Tools\WebserviceBundle\Configuration\WsSecurity;

class AttributeGroupController extends AbstractController
{

    /**
     *
     * @Route("/")
     * @WsRoute()
     * @WsSecurity({"ServiceProvider", "ServiceCountry", "ServiceTrigger"})
     * @Method({"POST"})
     * @param Request $request
     * @return Response
     */
    public function showAction(Request $request)
    {
        $xmlRequest = $request->attributes->get('XmlRequest');

        foreach ($xmlRequest->AttributeGroup->Show as $xmlRecord) {
            $this->worker()->attributeGroup()->show($xmlRecord);
        }

        $status = 200;
        if ($this->apiM()->errors()->hasErrors()) {
            $status = 400;
        }

        return new Response($this->apiM()->responseBuilder()->output(), $status, array('Content-Type' => 'text/xml; charset=UTF-8'));
    }

    /**
     *
     * @Route("/")
     * @WsRoute()
     * @WsSecurity({"ServiceProvider", "ServiceCountry", "ServiceTrigger"})
     * @Method({"POST"})
     */
    public function addAction(Request $request)
    {
        $xmlRequest = $request->attributes->get('XmlRequest');

        foreach ($xmlRequest->AttributeGroup->Add as $xmlRecord) {
            $this->worker()->attributeGroup()->add($xmlRecord);
        }

        $status = 200;
        if ($this->apiM()->errors()->hasErrors()) {
            $status = 400;
        }

        return new Response($this->apiM()->responseBuilder()->output(), $status, array('Content-Type' => 'text/xml; charset=UTF-8'));
    }

    /**
     *
     * @Route("/")
     * @WsRoute()
     * @WsSecurity({"ServiceProvider", "ServiceCountry", "ServiceTrigger"})
     * @Method({"POST"})
     * @param Request $request
     * @return Response
     */
    public function updateAction(Request $request)
    {
        $xmlRequest = $request->attributes->get('XmlRequest');

        foreach ($xmlRequest->AttributeGroup->Update as $xmlRecord) {
            $this->worker()->attributeGroup()->update($xmlRecord);
        }

        $status = 200;
        if ($this->apiM()->errors()->hasErrors()) {
            $status = 400;
        }

        return new Response($this->apiM()->responseBuilder()->output(), $status, array('Content-Type' => 'text/xml; charset=UTF-8'));
    }

    /**
     *
     * @Route("/")
     * @WsRoute()
     * @WsSecurity({"ServiceProvider", "ServiceCountry", "ServiceTrigger"})
     * @Method({"POST"})
     * @param Request $request
     * @return Response
     */
    public function deleteAction(Request $request)
    {
        $xmlRequest = $request->attributes->get('XmlRequest');

        foreach ($xmlRequest->AttributeGroup->Delete as $xmlRecord) {
            $this->worker()->attributeGroup()->delete($xmlRecord);
        }

        $status = 200;
        if ($this->apiM()->errors()->hasErrors()) {
            $status = 400;
        }

        return new Response($this->apiM()->responseBuilder()->output(), $status, array('Content-Type' => 'text/xml; charset=UTF-8'));
    }

}
