<?php

/**
 * Class ObjectController
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is protected by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2015 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 */

namespace Sso\Webservices\ObjectBundle\Controller;

use Sensio\Bundle\FrameworkExtraBundle\Configuration\Route;
use Sensio\Bundle\FrameworkExtraBundle\Configuration\Template;
use Sensio\Bundle\FrameworkExtraBundle\Configuration\Method;
use Symfony\Bundle\FrameworkBundle\Controller\Controller;
use Symfony\Component\HttpFoundation\Response;
use Symfony\Component\HttpFoundation\Request;
use Symfony\Component\Stopwatch\Stopwatch;
use LifeStyle\Tools\WebserviceBundle\Configuration\WsRoute;
use LifeStyle\Tools\WebserviceBundle\Configuration\WsSecurity;

/**
 * Class ObjectController
 *
 * @copyright  2015 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 * @package    Sso\Webservices\ObjectBundle\Controller
 */
class ObjectController extends AbstractController
{

    /**
     *
     * @Route("/")
     * @WsRoute()
     * @WsSecurity({"ServiceProvider", "ServiceCountry", "ServiceTrigger"})
     * @Method({"POST"})
     *
     * @param Request $request
     * @return Response
     */
    public function showSingleAction(Request $request)
    {
        $xmlRequest = $request->attributes->get('XmlRequest');

        foreach ($xmlRequest->Object->ShowSingle as $xmlRecord) {
            $this->worker()->object()->showSingle($xmlRecord);
        }

        $status = 200;
        if ($this->apiM()->errors()->hasErrors()) {
            $status = 400;
        }

        return new Response($this->apiM()->responseBuilder()->output(), $status, array('Content-Type' => 'text/xml; charset=UTF-8'));
    }

    /**
     *
     * @Route("/")
     * @WsRoute()
     * @WsSecurity({"ServiceProvider", "ServiceCountry", "ServiceTrigger"})
     * @Method({"POST"})
     *
     * @param Request $request
     * @return Response
     */
    public function showMultiAction(Request $request)
    {
        $xmlRequest = $request->attributes->get('XmlRequest');

        foreach ($xmlRequest->Object->ShowMulti as $xmlRecord) {
            $this->worker()->object()->showMulti($xmlRecord);
        }

        $status = 200;
        if ($this->apiM()->errors()->hasErrors()) {
            $status = 400;
        }

        return new Response($this->apiM()->responseBuilder()->output(), $status, array('Content-Type' => 'text/xml; charset=UTF-8'));
    }

    /**
     *
     * @Route("/")
     * @WsRoute()
     * @WsSecurity({"ServiceProvider", "ServiceCountry", "ServiceTrigger"})
     * @Method({"POST"})
     *
     * @param Request $request
     * @return Response
     */
    public function treeViewAction(Request $request)
    {
        $xmlRequest = $request->attributes->get('XmlRequest');

        foreach ($xmlRequest->Object->TreeView as $xmlRecord) {
            $this->worker()->object()->treeView($xmlRecord);
        }

        $status = 200;
        if ($this->apiM()->errors()->hasErrors()) {
            $status = 400;
        }

        return new Response($this->apiM()->responseBuilder()->output(), $status, array('Content-Type' => 'text/xml; charset=UTF-8'));
    }

    /**
     *
     * @Route("/")
     * @WsRoute()
     * @WsSecurity({"ServiceProvider", "ServiceCountry", "ServiceTrigger"})
     * @Method({"POST"})
     *
     * @param Request $request
     * @return Response
     */
    public function updateAction(Request $request)
    {
        $xmlRequest = $request->attributes->get('XmlRequest');

        foreach ($xmlRequest->Object->Update as $xmlRecord) {
            $this->worker()->object()->update($xmlRecord);
        }

        $status = 200;
        if ($this->apiM()->errors()->hasErrors()) {
            $status = 400;
        }

        return new Response($this->apiM()->responseBuilder()->output(), $status, array('Content-Type' => 'text/xml; charset=UTF-8'));
    }

    /**
     *
     * @Route("/")
     * @WsRoute()
     * @WsSecurity({"ServiceProvider", "ServiceCountry", "ServiceTrigger"})
     * @Method({"POST"})
     *
     * @param Request $request
     * @return Response
     */
    public function addAction(Request $request)
    {
        $xmlRequest = $request->attributes->get('XmlRequest');

        foreach ($xmlRequest->Object->Add as $xmlRecord) {
            $this->worker()->object()->add($xmlRecord);
        }

        $status = 200;
        if ($this->apiM()->errors()->hasErrors()) {
            $status = 400;
        }

        return new Response($this->apiM()->responseBuilder()->output(), $status, array('Content-Type' => 'text/xml; charset=UTF-8'));
    }

    /**
     *
     * @Route("/")
     * @WsRoute()
     * @WsSecurity({"ServiceProvider", "ServiceCountry", "ServiceTrigger"})
     * @Method({"POST"})
     *
     * @param Request $request
     * @return Response
     */
    public function deleteAction(Request $request)
    {
        $xmlRequest = $request->attributes->get('XmlRequest');

        foreach ($xmlRequest->Object->Delete as $xmlRecord) {
            $this->worker()->object()->delete($xmlRecord);
        }

        $status = 200;
        if ($this->apiM()->errors()->hasErrors()) {
            $status = 400;
        }

        return new Response($this->apiM()->responseBuilder()->output(), $status, array('Content-Type' => 'text/xml; charset=UTF-8'));
    }

}
