<?php

/**
 * Class LoadAttributeGroups
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is protected by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2015 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 */

namespace Sso\Webservices\ObjectBundle\DataFixtures\ORM;

use Doctrine\Common\DataFixtures\AbstractFixture;
use Doctrine\Common\DataFixtures\OrderedFixtureInterface;
use Doctrine\Common\Persistence\ObjectManager;
use Sso\Webservices\ObjectBundle\Entity\AttributeGroup;

/**
 * Class LoadAttributeGroups
 *
 * @copyright  2015 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 * @package    Sso\WebserviceBundle\DataFixtures\ORM\ServiceProvider
 */
class LoadAttributeGroups extends AbstractFixture implements OrderedFixtureInterface
{

    /**
     * {@inheritDoc}
     */
    public function load(ObjectManager $manager)
    {
        $rows = [
            ['1B9BADBF-0DD7-AF27-842A-CED56DD773B5', 'UnitTestAttributeGroupOne', 'BB25734E-BFF8-878A-E4F7-B2F0F38142F7'],
            ['B3AB16CB-8E3D-36D7-33A6-B59A7CD7C49E', 'UnitTestAttributeGroupTwo', 'E43752BB-E4F7-878A-BFF8-B2F0F38142F7'],
        ];

        foreach ($rows as $row) {

            $typeEntity = $manager->getRepository('SsoWebservicesObjectBundle:Type')->find($row[2]);

            $entity = new AttributeGroup();
            $entity->setName($row[1])
                   ->setCreatedAt()
                   ->addType($typeEntity)
            ;

            $manager->persist($entity);

            $entity->setId($row[0]);
        }

        $manager->flush();
    }

    /**
     * {@inheritDoc}
     */
    public function getOrder()
    {
        return 0;
    }

}
