<?php

/**
 * Class LoadAttributes
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is protected by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2015 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 */

namespace Sso\Webservices\ObjectBundle\DataFixtures\ORM;

use Doctrine\Common\DataFixtures\AbstractFixture;
use Doctrine\Common\DataFixtures\OrderedFixtureInterface;
use Doctrine\Common\Persistence\ObjectManager;
use Sso\Webservices\ObjectBundle\Entity\Attribute;

/**
 * Class LoadAttributes
 *
 * @copyright  2015 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 * @package    Sso\WebserviceBundle\DataFixtures\ORM\ServiceProvider
 */
class LoadAttributes extends AbstractFixture implements OrderedFixtureInterface
{

    /**
     * {@inheritDoc}
     */
    public function load(ObjectManager $manager)
    {
        $rows = [
            ['0C7D874E-A114-BF02-81D4-EC7935C748CA', '1B9BADBF-0DD7-AF27-842A-CED56DD773B5', 'UnitTestAttributeOne'],
            ['229B72CA-1927-68B2-5AEB-E87C74AF717E', '1B9BADBF-0DD7-AF27-842A-CED56DD773B5', 'UnitTestAttributeTwo'],
        ];

        foreach ($rows as $row) {

            $attrGroupEntity = $manager->getRepository('SsoWebservicesObjectBundle:AttributeGroup')->find($row[1]);

            $entity = new Attribute();
            $entity
                ->setAttributeGroup($attrGroupEntity)
                ->setName($row[2])
            ;

            $manager->persist($entity);

            $entity->setId($row[0]);
        }

        $manager->flush();
    }

    /**
     * {@inheritDoc}
     */
    public function getOrder()
    {
        return 1;
    }

}
