<?php

/**
 * Class LoadAttributeValues
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is protected by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2016 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 */

namespace Sso\Webservices\ObjectBundle\DataFixtures\ORM;

use Doctrine\Common\DataFixtures\AbstractFixture;
use Doctrine\Common\DataFixtures\OrderedFixtureInterface;
use Doctrine\Common\Persistence\ObjectManager;
use Sso\Webservices\ObjectBundle\Entity\ObjectAttributeValue;
use Sso\Webservices\ObjectBundle\Entity\Language;

/**
 * Class LoadAttributeValues
 *
 * @copyright  2016 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 * @package    Sso\WebserviceBundle\DataFixtures\ORM\ServiceProvider
 */
class LoadAttributeValues extends AbstractFixture implements OrderedFixtureInterface
{

    /**
     * {@inheritDoc}
     */
    public function load(ObjectManager $manager)
    {
        $rows = [
            ['24F07207-4874-7CD2-0A3D-271146ED10F3', '16FA40FD-5F4B-4937-F53E-F598471AAFD8', '0C7D874E-A114-BF02-81D4-EC7935C748CA', 'UnitTestValueEN', 'en'],
            ['F9F07207-7CD2-4874-4A1D-U71146ED10F3', '16FA40FD-5F4B-4937-F53E-F598471AAFD8', '0C7D874E-A114-BF02-81D4-EC7935C748CA', 'UnitTestValueDE', 'de'],
        ];

        foreach ($rows as $row) {

            $languageEntity = $manager->getRepository('SsoWebservicesObjectBundle:Language')->find($row[4]);
            $objectEntity = $manager->getRepository('SsoWebservicesObjectBundle:Object')->find($row[1]);
            $attrEntity = $manager->getRepository('SsoWebservicesObjectBundle:Attribute')->find($row[2]);

            $entity = new ObjectAttributeValue();
            $entity
                ->setObject($objectEntity)
                ->setAttribute($attrEntity)
                ->setValue($row[3])
                ->setLanguage($languageEntity);

            $manager->persist($entity);

            $entity->setId($row[0]);
        }

        $manager->flush();
    }

    /**
     * {@inheritDoc}
     */
    public function getOrder()
    {
        return 3;
    }

}
